/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.lang.reflect.Method;
import java.util.Objects;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class ByteBuddyUtils {
    private ByteBuddyUtils() {
    }

    public static @UnknownKeyFor @NonNull @Initialized ClassLoadingStrategy<@UnknownKeyFor @NonNull @Initialized ClassLoader> getClassLoadingStrategy(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> targetClass) {
        ClassLoadingStrategy.Default strategy;
        boolean systemClass;
        ClassLoader classLoader = ReflectHelpers.findClassLoader(targetClass);
        boolean bl = systemClass = classLoader == null;
        if (ClassInjector.UsingLookup.isAvailable() && !systemClass) {
            try {
                Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles", true, classLoader);
                Object lookup = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
                Class<?> lookupClass = Class.forName("java.lang.invoke.MethodHandles$Lookup", true, classLoader);
                Method privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, lookupClass);
                Object privateLookup = Objects.requireNonNull(privateLookupIn.invoke(null, targetClass, lookup));
                strategy = ClassLoadingStrategy.UsingLookup.of((Object)Objects.requireNonNull(privateLookup));
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("No code generation strategy available " + targetClass + " " + classLoader, e);
            }
        } else if (ClassInjector.UsingReflection.isAvailable()) {
            strategy = ClassLoadingStrategy.Default.INJECTION;
        } else {
            throw new IllegalStateException("No code generation strategy available");
        }
        return strategy;
    }
}

