/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueHaver;
import org.apache.beam.sdk.schemas.FieldValueSetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.schemas.utils.StaticSchemaInference;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JavaBeanUtils {
    private static final @UnknownKeyFor @NonNull @Initialized String X_WITH_NULL_METHOD_ERROR_FMT = "a %s FieldValueTypeInformation object has a null method field";
    public static final @UnknownKeyFor @NonNull @Initialized String GETTER_WITH_NULL_METHOD_ERROR = String.format("a %s FieldValueTypeInformation object has a null method field", "getter");
    public static final @UnknownKeyFor @NonNull @Initialized String SETTER_WITH_NULL_METHOD_ERROR = String.format("a %s FieldValueTypeInformation object has a null method field", "setter");
    private static final @UnknownKeyFor @NonNull @Initialized String CONSTRUCTOR_HELP_STRING = "In order to infer a Schema from a Java Bean, it must have a constructor annotated with @SchemaCreate, or it must have a compatible setter for every getter used as a Schema field.";
    private static final @UnknownKeyFor @NonNull @Initialized ByteBuddy BYTE_BUDDY = new ByteBuddy();
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ReflectUtils.TypeDescriptorWithSchema<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation>> CACHED_FIELD_TYPES = Maps.newConcurrentMap();
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ReflectUtils.TypeDescriptorWithSchema<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<@NonNull @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> CACHED_GETTERS = Maps.newConcurrentMap();
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ReflectUtils.TypeDescriptorWithSchema<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueSetter>> CACHED_SETTERS = Maps.newConcurrentMap();
    public static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized ReflectUtils.TypeDescriptorWithSchema<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator> CACHED_CREATORS = Maps.newConcurrentMap();

    public static @UnknownKeyFor @NonNull @Initialized Schema schemaFromJavaBeanClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier) {
        return StaticSchemaInference.schemaFromClass(typeDescriptor, fieldValueTypeSupplier);
    }

    public static void validateJavaBean(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> getters, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> setters, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        HashMap<String, FieldValueTypeInformation> setterMap = new HashMap<String, FieldValueTypeInformation>();
        int bound = schema.getFieldCount();
        for (int i = 0; i < bound; ++i) {
            Integer integer = i;
            if (setterMap.put(schema.getField(integer).getName(), setters.get(integer)) == null) continue;
            throw new IllegalStateException("Duplicate key");
        }
        for (FieldValueTypeInformation type : getters) {
            FieldValueTypeInformation setterType = (FieldValueTypeInformation)setterMap.get(type.getName());
            Method m = (Method)Preconditions.checkNotNull((Object)type.getMethod(), (Object)GETTER_WITH_NULL_METHOD_ERROR);
            if (setterType == null) {
                throw new RuntimeException(String.format("Java Bean '%s' contains a getter for field '%s', but does not contain a matching setter. %s", m.getDeclaringClass(), type.getName(), CONSTRUCTOR_HELP_STRING));
            }
            if (!type.getType().equals(setterType.getType())) {
                throw new RuntimeException(String.format("Java Bean '%s' contains a setter for field '%s' that has a mismatching type. %s", m.getDeclaringClass(), type.getName(), CONSTRUCTOR_HELP_STRING));
            }
            if (!type.isNullable() != setterType.isNullable()) continue;
            throw new RuntimeException(String.format("Java Bean '%s' contains a setter for field '%s' that has a mismatching nullable attribute. %s", m.getDeclaringClass(), type.getName(), CONSTRUCTOR_HELP_STRING));
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> getFieldTypes(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier) {
        return CACHED_FIELD_TYPES.computeIfAbsent(ReflectUtils.TypeDescriptorWithSchema.create(typeDescriptor, schema), c -> fieldValueTypeSupplier.get(typeDescriptor, schema));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<@NonNull T, @UnknownKeyFor @NonNull @Initialized Object>> getGetters(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return CACHED_GETTERS.computeIfAbsent(ReflectUtils.TypeDescriptorWithSchema.create(typeDescriptor, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(typeDescriptor, schema);
            return types.stream().map(t -> JavaBeanUtils.createGetter(t, typeConversionsFactory)).collect(Collectors.toList());
        });
    }

    public static <ObjectT, ValueT> @UnknownKeyFor @NonNull @Initialized FieldValueGetter<ObjectT, ValueT> createGetter(@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation typeInformation, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        Method m = (Method)Preconditions.checkNotNull((Object)typeInformation.getMethod(), (Object)GETTER_WITH_NULL_METHOD_ERROR);
        DynamicType.Builder builder = ByteBuddyUtils.subclassGetterInterface(BYTE_BUDDY, m.getDeclaringClass(), typeConversionsFactory.createTypeConversion(false).convert(typeInformation.getType()));
        builder = JavaBeanUtils.implementGetterMethods(builder, typeInformation, typeConversionsFactory);
        try {
            return (FieldValueGetter)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(m.getDeclaringClass().getClassLoader()), org.apache.beam.sdk.util.ByteBuddyUtils.getClassLoadingStrategy(m.getDeclaringClass())).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a getter for getter '" + typeInformation.getMethod() + "'");
        }
    }

    private static <ObjectT, ValueT> // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DynamicType.Builder<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<ObjectT, ValueT>> implementGetterMethods(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DynamicType.Builder<@UnknownKeyFor @NonNull @Initialized FieldValueGetter<ObjectT, ValueT>> builder, @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation typeInformation, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return builder.method((ElementMatcher)ElementMatchers.named((String)"name")).intercept((Implementation)FixedValue.reference((Object)typeInformation.getName())).method((ElementMatcher)ElementMatchers.named((String)"get")).intercept((Implementation)new InvokeGetterInstruction(typeInformation, typeConversionsFactory));
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueSetter> getSetters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return CACHED_SETTERS.computeIfAbsent(ReflectUtils.TypeDescriptorWithSchema.create(typeDescriptor, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(typeDescriptor, schema);
            return types.stream().map(t -> JavaBeanUtils.createSetter(t, typeConversionsFactory)).collect(Collectors.toList());
        });
    }

    public static <ObjectT, ValueT> @UnknownKeyFor @NonNull @Initialized FieldValueSetter<ObjectT, ValueT> createSetter(@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation typeInformation, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        Method m = (Method)Preconditions.checkNotNull((Object)typeInformation.getMethod(), (Object)SETTER_WITH_NULL_METHOD_ERROR);
        DynamicType.Builder builder = ByteBuddyUtils.subclassSetterInterface(BYTE_BUDDY, m.getDeclaringClass(), typeConversionsFactory.createTypeConversion(false).convert(typeInformation.getType()));
        builder = JavaBeanUtils.implementSetterMethods(builder, typeInformation, typeConversionsFactory);
        try {
            return (FieldValueSetter)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(m.getDeclaringClass().getClassLoader()), org.apache.beam.sdk.util.ByteBuddyUtils.getClassLoadingStrategy(m.getDeclaringClass())).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a setter for setter '" + typeInformation.getMethod() + "'");
        }
    }

    private static <ObjectT, ValueT> // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DynamicType.Builder<@UnknownKeyFor @NonNull @Initialized FieldValueSetter<ObjectT, ValueT>> implementSetterMethods(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DynamicType.Builder<@UnknownKeyFor @NonNull @Initialized FieldValueSetter<ObjectT, ValueT>> builder, @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation fieldValueTypeInformation, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return builder.method((ElementMatcher)ElementMatchers.named((String)"name")).intercept((Implementation)FixedValue.reference((Object)fieldValueTypeInformation.getName())).method((ElementMatcher)ElementMatchers.named((String)"set")).intercept((Implementation)new InvokeSetterInstruction(fieldValueTypeInformation, typeConversionsFactory));
    }

    public static <ObjectT> @UnknownKeyFor @NonNull @Initialized FieldValueHaver<ObjectT> createHaver(@UnknownKeyFor @NonNull @Initialized Class<ObjectT> clazz, @UnknownKeyFor @NonNull @Initialized Method hasMethod) {
        DynamicType.Builder builder = ByteBuddyUtils.subclassHaverInterface(BYTE_BUDDY, clazz);
        builder = JavaBeanUtils.implementHaverMethods(builder, hasMethod);
        try {
            return (FieldValueHaver)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(clazz.getClassLoader()), org.apache.beam.sdk.util.ByteBuddyUtils.getClassLoadingStrategy(clazz)).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a have for hasMethod '" + hasMethod + "'", e);
        }
    }

    private static <ObjectT> // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DynamicType.Builder<@UnknownKeyFor @NonNull @Initialized FieldValueHaver<ObjectT>> implementHaverMethods(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DynamicType.Builder<@UnknownKeyFor @NonNull @Initialized FieldValueHaver<ObjectT>> builder, @UnknownKeyFor @NonNull @Initialized Method hasMethod) {
        return builder.method((ElementMatcher)ElementMatchers.named((String)"name")).intercept((Implementation)FixedValue.reference((Object)hasMethod.getName())).method((ElementMatcher)ElementMatchers.named((String)"has")).intercept((Implementation)new InvokeHaverInstruction(hasMethod));
    }

    public static @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator getConstructorCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Constructor constructor, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return CACHED_CREATORS.computeIfAbsent(ReflectUtils.TypeDescriptorWithSchema.create(typeDescriptor, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(typeDescriptor, schema);
            return JavaBeanUtils.createConstructorCreator(typeDescriptor.getRawType(), constructor, schema, types, typeConversionsFactory);
        });
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator createConstructorCreator(@UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized Constructor<T> constructor, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> types, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = BYTE_BUDDY.with((NamingStrategy)new ByteBuddyUtils.InjectPackageStrategy(clazz)).subclass(SchemaUserTypeCreator.class).method((ElementMatcher)ElementMatchers.named((String)"create")).intercept((Implementation)new ByteBuddyUtils.ConstructorCreateInstruction(types, clazz, constructor, typeConversionsFactory));
            return (SchemaUserTypeCreator)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(clazz.getClassLoader()), org.apache.beam.sdk.util.ByteBuddyUtils.getClassLoadingStrategy(clazz)).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a creator for class " + clazz + " with schema " + schema);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator getStaticCreator(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Method creator, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized FieldValueTypeSupplier fieldValueTypeSupplier, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        return CACHED_CREATORS.computeIfAbsent(ReflectUtils.TypeDescriptorWithSchema.create(typeDescriptor, schema), c -> {
            List<FieldValueTypeInformation> types = fieldValueTypeSupplier.get(typeDescriptor, schema);
            return JavaBeanUtils.createStaticCreator(typeDescriptor.getRawType(), creator, schema, types, typeConversionsFactory);
        });
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SchemaUserTypeCreator createStaticCreator(@UnknownKeyFor @NonNull @Initialized Class<T> clazz, @UnknownKeyFor @NonNull @Initialized Method creator, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation> types, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
        try {
            DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = BYTE_BUDDY.with((NamingStrategy)new ByteBuddyUtils.InjectPackageStrategy(clazz)).subclass(SchemaUserTypeCreator.class).method((ElementMatcher)ElementMatchers.named((String)"create")).intercept((Implementation)new ByteBuddyUtils.StaticFactoryMethodInstruction(types, clazz, creator, typeConversionsFactory));
            return (SchemaUserTypeCreator)builder.visit((AsmVisitorWrapper)new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(clazz.getClassLoader()), org.apache.beam.sdk.util.ByteBuddyUtils.getClassLoadingStrategy(clazz)).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to generate a creator for " + clazz + " with schema " + schema);
        }
    }

    public static <T, K extends Comparable<? super K>> @UnknownKeyFor @NonNull @Initialized Comparator<T> comparingNullFirst(@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @Nullable @Initialized ? super T, @KeyForBottom @NonNull @Initialized ? extends @Nullable K> keyExtractor) {
        return Comparator.comparing(keyExtractor, Comparator.nullsFirst(Comparator.naturalOrder()));
    }

    private static class InvokeHaverInstruction
    implements Implementation {
        private final @UnknownKeyFor @NonNull @Initialized Method hasMethod;

        public InvokeHaverInstruction(@UnknownKeyFor @NonNull @Initialized Method hasMethod) {
            this.hasMethod = hasMethod;
        }

        public @UnknownKeyFor @NonNull @Initialized ByteCodeAppender appender(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation.Size size = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(1), MethodInvocation.invoke((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(this.hasMethod)), MethodReturn.INTEGER}).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }

        public @UnknownKeyFor @NonNull @Initialized InstrumentedType prepare(@UnknownKeyFor @NonNull @Initialized InstrumentedType instrumentedType) {
            return instrumentedType;
        }
    }

    private static class InvokeSetterInstruction
    implements Implementation {
        private @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation fieldValueTypeInformation;
        private final @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory;

        InvokeSetterInstruction(@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation fieldValueTypeInformation, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
            this.fieldValueTypeInformation = fieldValueTypeInformation;
            this.typeConversionsFactory = typeConversionsFactory;
        }

        public @UnknownKeyFor @NonNull @Initialized InstrumentedType prepare(@UnknownKeyFor @NonNull @Initialized InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public @UnknownKeyFor @NonNull @Initialized ByteCodeAppender appender(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation readField = MethodVariableAccess.REFERENCE.loadFrom(2);
                Method method = (Method)Preconditions.checkNotNull((Object)this.fieldValueTypeInformation.getMethod(), (Object)SETTER_WITH_NULL_METHOD_ERROR);
                boolean setterMethodReturnsVoid = method.getReturnType().equals(Void.TYPE);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(1), this.typeConversionsFactory.createSetterConversions(readField).convert(this.fieldValueTypeInformation.getType()), MethodInvocation.invoke((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(method))});
                if (!setterMethodReturnsVoid) {
                    stackManipulation = new StackManipulation.Compound(new StackManipulation[]{stackManipulation, Removal.SINGLE});
                }
                stackManipulation = new StackManipulation.Compound(new StackManipulation[]{stackManipulation, MethodReturn.VOID});
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }

    private static class InvokeGetterInstruction
    implements Implementation {
        private final @UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation typeInformation;
        private final @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory;

        InvokeGetterInstruction(@UnknownKeyFor @NonNull @Initialized FieldValueTypeInformation typeInformation, @UnknownKeyFor @NonNull @Initialized ByteBuddyUtils.TypeConversionsFactory typeConversionsFactory) {
            this.typeInformation = typeInformation;
            this.typeConversionsFactory = typeConversionsFactory;
        }

        public @UnknownKeyFor @NonNull @Initialized InstrumentedType prepare(@UnknownKeyFor @NonNull @Initialized InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public @UnknownKeyFor @NonNull @Initialized ByteCodeAppender appender(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation.Compound readValue = new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(1), MethodInvocation.invoke((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod((Method)Preconditions.checkNotNull((Object)this.typeInformation.getMethod(), (Object)GETTER_WITH_NULL_METHOD_ERROR)))});
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(new StackManipulation[]{this.typeConversionsFactory.createGetterConversions((StackManipulation)readValue).convert(this.typeInformation.getType()), MethodReturn.REFERENCE});
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }
    }
}

