/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.time.Instant;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MicrosInstant
implements Schema.LogicalType<Instant, Row> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = (String)SchemaApi.LogicalTypes.Enum.MICROS_INSTANT.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);
    private final @UnknownKeyFor @NonNull @Initialized Schema schema = Schema.builder().addInt64Field("seconds").addInt32Field("micros").build();

    @Override
    public @UnknownKeyFor @NonNull @Initialized Row toBaseType(@UnknownKeyFor @NonNull @Initialized Instant input) {
        if (input.getNano() % 1000 != 0) {
            throw new AssertionError((Object)"micros_instant logical type encountered a Java Instant with greater than microsecond precision.");
        }
        return Row.withSchema(this.schema).addValues(input.getEpochSecond(), input.getNano() / 1000).build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant toInputType(@UnknownKeyFor @NonNull @Initialized Row row) {
        return Instant.ofEpochSecond(Preconditions.checkArgumentNotNull(row.getInt64(0), "While trying to convert to Instant: Row missing seconds field"), Preconditions.checkArgumentNotNull(row.getInt32(1), "While trying to convert to Instant: Row missing micros field") * 1000);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Schema.FieldType getArgumentType() {
        return null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getBaseType() {
        return Schema.FieldType.row(this.schema);
    }
}

