/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuralByteArray;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.CountingOutputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public abstract class Coder<@UnknownKeyFor T>
implements Serializable {
    public abstract void encode(T var1, @UnknownKeyFor @NonNull @Initialized OutputStream var2) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException;

    @Deprecated
    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        this.encode(value, outStream);
    }

    public abstract T decode(@UnknownKeyFor @NonNull @Initialized InputStream var1) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException;

    @Deprecated
    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Context context) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        return this.decode(inStream);
    }

    public abstract /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments();

    public abstract void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized NonDeterministicException;

    public static void verifyDeterministic(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> target, @UnknownKeyFor @NonNull @Initialized String message, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> coders) throws @UnknownKeyFor @NonNull @Initialized NonDeterministicException {
        for (Coder<?> coder : coders) {
            try {
                coder.verifyDeterministic();
            }
            catch (NonDeterministicException e) {
                throw new NonDeterministicException(target, message, e);
            }
        }
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSizeUsingCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> target, T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return target.getEncodedElementByteSize(value);
    }

    public static void verifyDeterministic(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> target, @UnknownKeyFor @NonNull @Initialized String message, Coder<?> ... coders) throws @UnknownKeyFor @NonNull @Initialized NonDeterministicException {
        Coder.verifyDeterministic(target, message, Arrays.asList(coders));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(T value) {
        if (value != null && this.consistentWithEquals()) {
            return value;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.encode(value, os, Context.OUTER);
            return new StructuralByteArray(os.toByteArray());
        }
        catch (Exception exn) {
            throw new IllegalArgumentException("Unable to encode element '" + value + "' with coder '" + this + "'.", exn);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(T value) {
        return false;
    }

    public void registerByteSizeObserver(T value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        observer.update(this.getEncodedElementByteSize(value));
    }

    protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(T value) throws @UnknownKeyFor @NonNull @Initialized Exception {
        long l;
        CountingOutputStream os = new CountingOutputStream(ByteStreams.nullOutputStream());
        try {
            this.encode(value, (OutputStream)os);
            l = os.getCount();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exn) {
                throw new IllegalArgumentException("Unable to encode element '" + value + "' with coder '" + this + "'.", exn);
            }
        }
        os.close();
        return l;
    }

    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> getEncodedTypeDescriptor() {
        return TypeDescriptor.of(this.getClass()).resolveType(new TypeDescriptor<T>(){}.getType());
    }

    public static class NonDeterministicException
    extends Exception {
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> reasons;

        public NonDeterministicException(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder, @UnknownKeyFor @NonNull @Initialized String reason, @Nullable @UnknownKeyFor @Initialized NonDeterministicException e) {
            this(coder, Arrays.asList(reason), e);
        }

        public NonDeterministicException(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder, @UnknownKeyFor @NonNull @Initialized String reason) {
            this(coder, Arrays.asList(reason), null);
        }

        public NonDeterministicException(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> reasons) {
            this(coder, reasons, null);
        }

        public NonDeterministicException(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> reasons, @Nullable @UnknownKeyFor @Initialized NonDeterministicException cause) {
            super(cause);
            Preconditions.checkArgument((reasons.size() > 0 ? 1 : 0) != 0, (Object)"Reasons must not be empty.");
            this.reasons = reasons;
            this.coder = coder;
        }

        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> getReasons() {
            return this.reasons;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized String getMessage() {
            String reasonsStr = Joiner.on((String)"\n\t").join(this.reasons);
            return this.coder + " is not deterministic because:\n\t" + reasonsStr;
        }
    }

    @Deprecated
    public static class Context {
        public static final @UnknownKeyFor @NonNull @Initialized Context OUTER = new Context(true);
        public static final @UnknownKeyFor @NonNull @Initialized Context NESTED = new Context(false);
        public final @UnknownKeyFor @NonNull @Initialized boolean isWholeStream;

        public Context(@UnknownKeyFor @NonNull @Initialized boolean isWholeStream) {
            this.isWholeStream = isWholeStream;
        }

        public @UnknownKeyFor @NonNull @Initialized Context nested() {
            return NESTED;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (!(obj instanceof Context)) {
                return false;
            }
            return Objects.equal((Object)this.isWholeStream, (Object)((Context)obj).isWholeStream);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.isWholeStream});
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(Context.class).addValue((Object)(this.isWholeStream ? "OUTER" : "NESTED")).toString();
        }
    }
}

