/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.PassthroughTransformEvaluator;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.construction.WindowIntoTranslation;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

class WindowEvaluatorFactory
implements TransformEvaluatorFactory {
    private final @UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext;

    WindowEvaluatorFactory(@UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    @Override
    public <InputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<InputT> forApplication(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputBundle) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return this.createTransformEvaluator(application);
    }

    private <InputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<InputT> createTransformEvaluator(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollection<InputT>,  @UnknownKeyFor @NonNull @Initialized Window.Assign<InputT>> transform) {
        WindowFn<?, ?> fn = WindowIntoTranslation.getWindowFn(transform);
        UncommittedBundle outputBundle = this.evaluationContext.createBundle((PCollection)Iterables.getOnlyElement(transform.getOutputs().values()));
        if (fn == null) {
            return PassthroughTransformEvaluator.create(transform, outputBundle);
        }
        return new WindowIntoEvaluator<InputT>(transform, fn, outputBundle);
    }

    @Override
    public void cleanup() {
    }

    private static class DirectAssignContext<@UnknownKeyFor InputT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    extends WindowFn.AssignContext {
        private final @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> value;

        public DirectAssignContext(@UnknownKeyFor @NonNull @Initialized WindowFn<InputT, W> fn, @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> value) {
            super(fn);
            this.value = value;
        }

        public InputT element() {
            return this.value.getValue();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant timestamp() {
            return this.value.getTimestamp();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
            return (BoundedWindow)Iterables.getOnlyElement(this.value.getWindows());
        }
    }

    private static class WindowIntoEvaluator<@UnknownKeyFor InputT>
    implements TransformEvaluator<InputT> {
        private final @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollection<InputT>,  @UnknownKeyFor @NonNull @Initialized Window.Assign<InputT>> transform;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowFn<InputT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowFn;
        private final @UnknownKeyFor @NonNull @Initialized UncommittedBundle<InputT> outputBundle;

        public WindowIntoEvaluator(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollection<InputT>,  @UnknownKeyFor @NonNull @Initialized Window.Assign<InputT>> transform, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @Nullable @Initialized ? super InputT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowFn, @UnknownKeyFor @NonNull @Initialized UncommittedBundle<InputT> outputBundle) {
            this.outputBundle = outputBundle;
            this.transform = transform;
            this.windowFn = windowFn;
        }

        @Override
        public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> compressedElement) throws @UnknownKeyFor @NonNull @Initialized Exception {
            for (WindowedValue<InputT> element : compressedElement.explodeWindows()) {
                Collection<BoundedWindow> windows = this.assignWindows(this.windowFn, element);
                ((WindowedValues.Builder)WindowedValues.builder(element).setWindows((Collection)windows)).setReceiver(this.outputBundle::add).output();
            }
        }

        private <W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> assignWindows(@UnknownKeyFor @NonNull @Initialized WindowFn<InputT, W> windowFn, @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> element) throws @UnknownKeyFor @NonNull @Initialized Exception {
            DirectAssignContext<InputT, W> assignContext = new DirectAssignContext<InputT, W>(windowFn, element);
            return windowFn.assignWindows(assignContext);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TransformResult<InputT> finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
            return StepTransformResult.withoutHold(this.transform).addOutput(this.outputBundle, new UncommittedBundle[0]).build();
        }
    }
}

