/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.core.AutoValue_TimerInternals_TimerData;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ComparisonChain;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

public interface TimerInternals {
    public void setTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace var1, @UnknownKeyFor @NonNull @Initialized String var2, @UnknownKeyFor @NonNull @Initialized String var3, @UnknownKeyFor @NonNull @Initialized Instant var4, @UnknownKeyFor @NonNull @Initialized Instant var5, @UnknownKeyFor @NonNull @Initialized TimeDomain var6);

    @Deprecated
    public void setTimer(@UnknownKeyFor @NonNull @Initialized TimerData var1);

    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace var1, @UnknownKeyFor @NonNull @Initialized String var2, @UnknownKeyFor @NonNull @Initialized String var3, @UnknownKeyFor @NonNull @Initialized TimeDomain var4);

    @Deprecated
    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace var1, @UnknownKeyFor @NonNull @Initialized String var2, @UnknownKeyFor @NonNull @Initialized String var3);

    @Deprecated
    public void deleteTimer(@UnknownKeyFor @NonNull @Initialized TimerData var1);

    public @UnknownKeyFor @NonNull @Initialized Instant currentProcessingTime();

    public @Nullable @UnknownKeyFor @Initialized Instant currentSynchronizedProcessingTime();

    public @UnknownKeyFor @NonNull @Initialized Instant currentInputWatermarkTime();

    public @Nullable @UnknownKeyFor @Initialized Instant currentOutputWatermarkTime();

    public static class TimerDataCoder
    extends StructuredCoder<TimerData> {
        private static final @UnknownKeyFor @NonNull @Initialized StringUtf8Coder STRING_CODER = StringUtf8Coder.of();
        private static final @UnknownKeyFor @NonNull @Initialized InstantCoder INSTANT_CODER = InstantCoder.of();
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;

        public static @UnknownKeyFor @NonNull @Initialized TimerDataCoder of(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            return new TimerDataCoder(windowCoder);
        }

        private TimerDataCoder(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            this.windowCoder = windowCoder;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized TimerData timer, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            STRING_CODER.encode(timer.getTimerId(), outStream);
            STRING_CODER.encode(timer.getNamespace().stringKey(), outStream);
            INSTANT_CODER.encode(timer.getTimestamp(), outStream);
            STRING_CODER.encode(timer.getDomain().name(), outStream);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TimerData decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            String timerId = STRING_CODER.decode(inStream);
            StateNamespace namespace = StateNamespaces.fromString(STRING_CODER.decode(inStream), this.windowCoder);
            Instant timestamp = INSTANT_CODER.decode(inStream);
            TimeDomain domain = TimeDomain.valueOf(STRING_CODER.decode(inStream));
            return TimerData.of(timerId, namespace, timestamp, timestamp, domain);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Arrays.asList(this.windowCoder);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            TimerDataCoder.verifyDeterministic(this, "window coder must be deterministic", this.windowCoder);
        }
    }

    public static class TimerDataCoderV2
    extends StructuredCoder<TimerData> {
        private static final @UnknownKeyFor @NonNull @Initialized StringUtf8Coder STRING_CODER = StringUtf8Coder.of();
        private static final @UnknownKeyFor @NonNull @Initialized InstantCoder INSTANT_CODER = InstantCoder.of();
        private final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder;

        public static @UnknownKeyFor @NonNull @Initialized TimerDataCoderV2 of(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            return new TimerDataCoderV2(windowCoder);
        }

        private TimerDataCoderV2(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowCoder) {
            this.windowCoder = windowCoder;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized TimerData timer, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            STRING_CODER.encode(timer.getTimerId(), outStream);
            STRING_CODER.encode(timer.getTimerFamilyId(), outStream);
            STRING_CODER.encode(timer.getNamespace().stringKey(), outStream);
            INSTANT_CODER.encode(timer.getTimestamp(), outStream);
            INSTANT_CODER.encode(timer.getOutputTimestamp(), outStream);
            STRING_CODER.encode(timer.getDomain().name(), outStream);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TimerData decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            String timerId = STRING_CODER.decode(inStream);
            String timerFamilyId = STRING_CODER.decode(inStream);
            StateNamespace namespace = StateNamespaces.fromString(STRING_CODER.decode(inStream), this.windowCoder);
            Instant timestamp = INSTANT_CODER.decode(inStream);
            Instant outputTimestamp = INSTANT_CODER.decode(inStream);
            TimeDomain domain = TimeDomain.valueOf(STRING_CODER.decode(inStream));
            return TimerData.of(timerId, timerFamilyId, namespace, timestamp, outputTimestamp, domain);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Arrays.asList(this.windowCoder);
        }

        @Override
        public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            TimerDataCoderV2.verifyDeterministic(this, "window coder must be deterministic", this.windowCoder);
        }
    }

    @AutoValue
    public static abstract class TimerData
    implements Comparable<TimerData> {
        public abstract @UnknownKeyFor @NonNull @Initialized String getTimerId();

        public abstract @UnknownKeyFor @NonNull @Initialized String getTimerFamilyId();

        public abstract @UnknownKeyFor @NonNull @Initialized StateNamespace getNamespace();

        public abstract @UnknownKeyFor @NonNull @Initialized Instant getTimestamp();

        public abstract @UnknownKeyFor @NonNull @Initialized Instant getOutputTimestamp();

        public abstract @UnknownKeyFor @NonNull @Initialized TimeDomain getDomain();

        public abstract @UnknownKeyFor @NonNull @Initialized boolean getDeleted();

        public static @UnknownKeyFor @NonNull @Initialized TimerData of(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain domain) {
            return new AutoValue_TimerInternals_TimerData(timerId, "", namespace, timestamp, outputTimestamp, domain, false);
        }

        public static @UnknownKeyFor @NonNull @Initialized TimerData of(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain domain) {
            return new AutoValue_TimerInternals_TimerData(timerId, timerFamilyId, namespace, timestamp, outputTimestamp, domain, false);
        }

        public static @UnknownKeyFor @NonNull @Initialized TimerData of(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain domain) {
            String timerId = String.valueOf(domain.ordinal()) + ':' + timestamp.getMillis();
            return TimerData.of(timerId, namespace, timestamp, outputTimestamp, domain);
        }

        public @UnknownKeyFor @NonNull @Initialized TimerData deleted() {
            return new AutoValue_TimerInternals_TimerData(this.getTimerId(), this.getTimerFamilyId(), this.getNamespace(), this.getTimestamp(), this.getOutputTimestamp(), this.getDomain(), true);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized TimerData that) {
            if (this.equals(that)) {
                return 0;
            }
            ComparisonChain chain = ComparisonChain.start().compare(Boolean.valueOf(this.getDeleted()), Boolean.valueOf(that.getDeleted())).compare((Comparable)this.getTimestamp(), (Comparable)that.getTimestamp()).compare((Comparable)this.getOutputTimestamp(), (Comparable)that.getOutputTimestamp()).compare((Comparable)((Object)this.getDomain()), (Comparable)((Object)that.getDomain())).compare((Comparable)((Object)this.getTimerId()), (Comparable)((Object)that.getTimerId())).compare((Comparable)((Object)this.getTimerFamilyId()), (Comparable)((Object)that.getTimerFamilyId()));
            int compResult = chain.result();
            if (compResult == 0 && !this.getNamespace().equals(that.getNamespace())) {
                compResult = this.getNamespace().stringKey().compareTo(that.getNamespace().stringKey());
            }
            return compResult;
        }

        public @UnknownKeyFor @NonNull @Initialized String stringKey() {
            return this.getNamespace().stringKey() + "/" + this.getDomain().toString() + "/" + this.getTimerFamilyId() + ":" + this.getTimerId();
        }
    }
}

