/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.state.TimerMap;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimator;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
public interface DoFnInvoker<@UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
    public void invokeSetup(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public void invokeStartBundle(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public void invokeFinishBundle(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public void invokeTeardown();

    public void invokeOnWindowExpiration(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public @UnknownKeyFor @NonNull @Initialized DoFn.ProcessContinuation invokeProcessElement(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public void invokeOnTimer(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized String var2, @UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var3);

    public <RestrictionT> RestrictionT invokeGetInitialRestriction(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public <RestrictionT> @UnknownKeyFor @NonNull @Initialized Coder<RestrictionT> invokeGetRestrictionCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry var1);

    public void invokeSplitRestriction(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public <RestrictionT> @Nullable @UnknownKeyFor @Initialized RestrictionTracker.TruncateResult<RestrictionT> invokeTruncateRestriction(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public @UnknownKeyFor @NonNull @Initialized double invokeGetSize(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public <RestrictionT, PositionT> @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> invokeNewTracker(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public <WatermarkEstimatorStateT> @UnknownKeyFor @NonNull @Initialized WatermarkEstimator<WatermarkEstimatorStateT> invokeNewWatermarkEstimator(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public <WatermarkEstimatorStateT> WatermarkEstimatorStateT invokeGetInitialWatermarkEstimatorState(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> var1);

    public <WatermarkEstimatorStateT> @UnknownKeyFor @NonNull @Initialized Coder<WatermarkEstimatorStateT> invokeGetWatermarkEstimatorStateCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry var1);

    public @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> getFn();

    @VisibleForTesting
    @Internal
    public static class FakeArgumentProvider<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends BaseArgumentProvider<InputT, OutputT> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
            return "TestContext";
        }
    }

    @Internal
    public static class DelegatingArgumentProvider<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    extends BaseArgumentProvider<InputT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> delegate;
        private final @UnknownKeyFor @NonNull @Initialized String errorContext;

        public DelegatingArgumentProvider(@UnknownKeyFor @NonNull @Initialized ArgumentProvider<InputT, OutputT> delegate, @UnknownKeyFor @NonNull @Initialized String errorContext) {
            this.delegate = delegate;
            this.errorContext = errorContext;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
            return this.delegate.window();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.paneInfo(doFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
            return this.delegate.pipelineOptions();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext startBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.startBundleContext(doFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext finishBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.finishBundleContext(doFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.processContext(doFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized OnTimerContext onTimerContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.onTimerContext(doFn);
        }

        @Override
        public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.element(doFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object key() {
            return this.delegate.key();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
            return this.delegate.sideInput(tagId);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object schemaElement(@UnknownKeyFor @NonNull @Initialized int index) {
            return this.delegate.schemaElement(index);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.timestamp(doFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.timeDomain(doFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<OutputT> outputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.outputReceiver(doFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> outputRowReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.outputRowReceiver(doFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver taggedOutputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.taggedOutputReceiver(doFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object restriction() {
            return this.delegate.restriction();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
            return this.delegate.restrictionTracker();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object watermarkEstimatorState() {
            return this.delegate.watermarkEstimatorState();
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WatermarkEstimator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> watermarkEstimator() {
            return this.delegate.watermarkEstimator();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized State state(@UnknownKeyFor @NonNull @Initialized String stateId, @UnknownKeyFor @NonNull @Initialized boolean alwaysFetch) {
            return this.delegate.state(stateId, alwaysFetch);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Timer timer(@UnknownKeyFor @NonNull @Initialized String timerId) {
            return this.delegate.timer(timerId);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TimerMap timerFamily(@UnknownKeyFor @NonNull @Initialized String timerFamilyId) {
            return this.delegate.timerFamily(timerFamilyId);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String timerId(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            return this.delegate.timerId(doFn);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer() {
            return this.delegate.bundleFinalizer();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
            return this.errorContext;
        }
    }

    @Internal
    public static abstract class BaseArgumentProvider<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements ArgumentProvider<InputT, OutputT> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("ProcessContext unsupported in %s", this.getErrorContext()));
        }

        @Override
        public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("Element unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object key() {
            throw new UnsupportedOperationException("Cannot access key as parameter outside of @OnTimer method.");
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
            throw new UnsupportedOperationException(String.format("SideInput unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TimerMap timerFamily(@UnknownKeyFor @NonNull @Initialized String tagId) {
            throw new UnsupportedOperationException(String.format("TimerFamily unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object schemaElement(@UnknownKeyFor @NonNull @Initialized int index) {
            throw new UnsupportedOperationException(String.format("Schema element unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("Timestamp unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String timerId(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("TimerId unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("TimeDomain unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<OutputT> outputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("OutputReceiver unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> outputRowReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("Row OutputReceiver unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver taggedOutputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("MultiOutputReceiver unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object restriction() {
            throw new UnsupportedOperationException(String.format("Restriction unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
            throw new UnsupportedOperationException(String.format("BoundedWindow unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("PaneInfo unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
            throw new UnsupportedOperationException(String.format("PipelineOptions unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext startBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("StartBundleContext unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext finishBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("FinishBundleContext unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized OnTimerContext onTimerContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
            throw new UnsupportedOperationException(String.format("OnTimerContext unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized State state(@UnknownKeyFor @NonNull @Initialized String stateId, @UnknownKeyFor @NonNull @Initialized boolean alwaysFetched) {
            throw new UnsupportedOperationException(String.format("State unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Timer timer(@UnknownKeyFor @NonNull @Initialized String timerId) {
            throw new UnsupportedOperationException(String.format("Timer unsupported in %s", this.getErrorContext()));
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
            throw new UnsupportedOperationException(String.format("RestrictionTracker unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object watermarkEstimatorState() {
            throw new UnsupportedOperationException(String.format("WatermarkEstimatorState unsupported in %s", this.getErrorContext()));
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WatermarkEstimator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> watermarkEstimator() {
            throw new UnsupportedOperationException(String.format("WatermarkEstimator unsupported in %s", this.getErrorContext()));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer() {
            throw new UnsupportedOperationException(String.format("BundleFinalizer unsupported in %s", this.getErrorContext()));
        }

        public abstract @UnknownKeyFor @NonNull @Initialized String getErrorContext();
    }

    @Internal
    public static interface ArgumentProvider<@UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
        public @UnknownKeyFor @NonNull @Initialized BoundedWindow window();

        public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);

        public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions();

        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext startBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);

        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext finishBundleContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);

        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);

        public @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized OnTimerContext onTimerContext(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);

        public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);

        public @UnknownKeyFor @NonNull @Initialized Object key();

        public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String var1);

        public @UnknownKeyFor @NonNull @Initialized Object schemaElement(@UnknownKeyFor @NonNull @Initialized int var1);

        public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);

        public @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);

        public @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<OutputT> outputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);

        public @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> outputRowReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);

        public @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver taggedOutputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);

        public @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer();

        public @UnknownKeyFor @NonNull @Initialized Object restriction();

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker();

        public @UnknownKeyFor @NonNull @Initialized Object watermarkEstimatorState();

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WatermarkEstimator<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> watermarkEstimator();

        public @UnknownKeyFor @NonNull @Initialized State state(@UnknownKeyFor @NonNull @Initialized String var1, @UnknownKeyFor @NonNull @Initialized boolean var2);

        public @UnknownKeyFor @NonNull @Initialized Timer timer(@UnknownKeyFor @NonNull @Initialized String var1);

        public @UnknownKeyFor @NonNull @Initialized TimerMap timerFamily(@UnknownKeyFor @NonNull @Initialized String var1);

        public @UnknownKeyFor @NonNull @Initialized String timerId(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> var1);
    }
}

