/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.io.AutoValue_TFRecordWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class TFRecordWriteSchemaTransformConfiguration {
    public void validate() {
        String invalidConfigMessage = "Invalid TFRecord Write configuration: ";
        ErrorHandling errorHandling = this.getErrorHandling();
        if (errorHandling != null) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)errorHandling.getOutput()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Output must not be empty if error handling specified."));
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_TFRecordWriteSchemaTransformConfiguration.Builder();
    }

    @SchemaFieldDescription(value="The directory to which files will be written.")
    public abstract @UnknownKeyFor @NonNull @Initialized String getOutputPrefix();

    @SchemaFieldDescription(value="The suffix of each file written, combined with prefix and shardTemplate.")
    public abstract @Nullable @UnknownKeyFor @Initialized String getFilenameSuffix();

    @SchemaFieldDescription(value="The number of shards to use, or 0 for automatic.")
    public abstract @UnknownKeyFor @NonNull @Initialized int getNumShards();

    @SchemaFieldDescription(value="The shard template of each file written, combined with prefix and suffix.")
    public abstract @Nullable @UnknownKeyFor @Initialized String getShardTemplate();

    @SchemaFieldDescription(value="Option to indicate the output sink's compression type. Default is NONE.")
    public abstract @UnknownKeyFor @NonNull @Initialized String getCompression();

    @SchemaFieldDescription(value="Whether to skip the spilling of data caused by having maxNumWritersPerBundle.")
    public abstract @Nullable @UnknownKeyFor @Initialized Boolean getNoSpilling();

    @SchemaFieldDescription(value="Maximum number of writers created in a bundle before spilling to shuffle.")
    public abstract @Nullable @UnknownKeyFor @Initialized Integer getMaxNumWritersPerBundle();

    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    public abstract @Nullable @UnknownKeyFor @Initialized ErrorHandling getErrorHandling();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setOutputPrefix(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setShardTemplate(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFilenameSuffix(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setNumShards(@UnknownKeyFor @NonNull @Initialized int var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCompression(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setNoSpilling(@UnknownKeyFor @NonNull @Initialized Boolean var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxNumWritersPerBundle(@Nullable @UnknownKeyFor @Initialized Integer var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setErrorHandling(@UnknownKeyFor @NonNull @Initialized ErrorHandling var1);

        public abstract @UnknownKeyFor @NonNull @Initialized TFRecordWriteSchemaTransformConfiguration build();
    }
}

