/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.TFRecordReadSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;

final class AutoValue_TFRecordReadSchemaTransformConfiguration
extends TFRecordReadSchemaTransformConfiguration {
    private final boolean validate;
    private final String compression;
    private final String filePattern;
    private final ErrorHandling errorHandling;

    private AutoValue_TFRecordReadSchemaTransformConfiguration(boolean validate, String compression, String filePattern, @Nullable ErrorHandling errorHandling) {
        this.validate = validate;
        this.compression = compression;
        this.filePattern = filePattern;
        this.errorHandling = errorHandling;
    }

    @Override
    @SchemaFieldDescription(value="Validate file pattern.")
    public boolean getValidate() {
        return this.validate;
    }

    @Override
    @SchemaFieldDescription(value="Decompression type to use when reading input files.")
    public String getCompression() {
        return this.compression;
    }

    @Override
    @SchemaFieldDescription(value="Filename or file pattern used to find input files.")
    public String getFilePattern() {
        return this.filePattern;
    }

    @Override
    @Nullable
    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    public ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    public String toString() {
        return "TFRecordReadSchemaTransformConfiguration{validate=" + this.validate + ", compression=" + this.compression + ", filePattern=" + this.filePattern + ", errorHandling=" + this.errorHandling + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TFRecordReadSchemaTransformConfiguration) {
            TFRecordReadSchemaTransformConfiguration that = (TFRecordReadSchemaTransformConfiguration)o;
            return this.validate == that.getValidate() && this.compression.equals(that.getCompression()) && this.filePattern.equals(that.getFilePattern()) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.validate ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.compression.hashCode();
        h$ *= 1000003;
        h$ ^= this.filePattern.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
    }

    @Override
    TFRecordReadSchemaTransformConfiguration.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TFRecordReadSchemaTransformConfiguration.Builder {
        private Boolean validate;
        private String compression;
        private String filePattern;
        private ErrorHandling errorHandling;

        Builder() {
        }

        private Builder(TFRecordReadSchemaTransformConfiguration source) {
            this.validate = source.getValidate();
            this.compression = source.getCompression();
            this.filePattern = source.getFilePattern();
            this.errorHandling = source.getErrorHandling();
        }

        @Override
        public TFRecordReadSchemaTransformConfiguration.Builder setValidate(boolean validate) {
            this.validate = validate;
            return this;
        }

        @Override
        public TFRecordReadSchemaTransformConfiguration.Builder setCompression(String compression) {
            if (compression == null) {
                throw new NullPointerException("Null compression");
            }
            this.compression = compression;
            return this;
        }

        @Override
        public TFRecordReadSchemaTransformConfiguration.Builder setFilePattern(String filePattern) {
            if (filePattern == null) {
                throw new NullPointerException("Null filePattern");
            }
            this.filePattern = filePattern;
            return this;
        }

        @Override
        public TFRecordReadSchemaTransformConfiguration.Builder setErrorHandling(@Nullable ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public TFRecordReadSchemaTransformConfiguration build() {
            if (this.validate == null || this.compression == null || this.filePattern == null) {
                StringBuilder missing = new StringBuilder();
                if (this.validate == null) {
                    missing.append(" validate");
                }
                if (this.compression == null) {
                    missing.append(" compression");
                }
                if (this.filePattern == null) {
                    missing.append(" filePattern");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TFRecordReadSchemaTransformConfiguration(this.validate, this.compression, this.filePattern, this.errorHandling);
        }
    }
}

