/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.StepTransformResult;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformEvaluatorFactory;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class FlattenEvaluatorFactory
implements TransformEvaluatorFactory {
    private final @UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext;

    FlattenEvaluatorFactory(@UnknownKeyFor @NonNull @Initialized EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    @Override
    public <InputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<InputT> forApplication(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized CommittedBundle<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> inputBundle) {
        TransformEvaluator<InputT> evaluator = this.createInMemoryEvaluator(application);
        return evaluator;
    }

    @Override
    public void cleanup() throws @UnknownKeyFor @NonNull @Initialized Exception {
    }

    private <InputT> @UnknownKeyFor @NonNull @Initialized TransformEvaluator<InputT> createInMemoryEvaluator(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<InputT>, @UnknownKeyFor @NonNull @Initialized PCollection<InputT>,  @UnknownKeyFor @NonNull @Initialized Flatten.PCollections<InputT>> application) {
        UncommittedBundle outputBundle = this.evaluationContext.createBundle((PCollection)Iterables.getOnlyElement(application.getOutputs().values()));
        StepTransformResult result = StepTransformResult.withoutHold(application).addOutput(outputBundle, new UncommittedBundle[0]).build();
        return new FlattenEvaluator(outputBundle, result);
    }

    private static class FlattenEvaluator<@UnknownKeyFor InputT>
    implements TransformEvaluator<InputT> {
        private final @UnknownKeyFor @NonNull @Initialized UncommittedBundle<InputT> outputBundle;
        private final @UnknownKeyFor @NonNull @Initialized TransformResult<InputT> result;

        public FlattenEvaluator(@UnknownKeyFor @NonNull @Initialized UncommittedBundle<InputT> outputBundle, @UnknownKeyFor @NonNull @Initialized TransformResult<InputT> result) {
            this.outputBundle = outputBundle;
            this.result = result;
        }

        @Override
        public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> element) {
            this.outputBundle.add(element);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TransformResult<InputT> finishBundle() {
            return this.result;
        }
    }
}

