/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.beam.runners.core.metrics.AutoValue_StringSetData;
import org.apache.beam.sdk.metrics.StringSetResult;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoValue
public abstract class StringSetData
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(StringSetData.class);
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized long STRING_SET_SIZE_LIMIT = 1000000L;

    public abstract @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> stringSet();

    public abstract @UnknownKeyFor @NonNull @Initialized long stringSize();

    public static @UnknownKeyFor @NonNull @Initialized StringSetData create(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> set) {
        if (set.isEmpty()) {
            return StringSetData.empty();
        }
        HashSet<String> combined = new HashSet<String>();
        long stringSize = StringSetData.addUntilCapacity(combined, 0L, set);
        return new AutoValue_StringSetData(combined, stringSize);
    }

    private static @UnknownKeyFor @NonNull @Initialized StringSetData createInPlace(@UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> set, @UnknownKeyFor @NonNull @Initialized long stringSize) {
        return new AutoValue_StringSetData(set, stringSize);
    }

    public static @UnknownKeyFor @NonNull @Initialized StringSetData empty() {
        return EmptyStringSetData.INSTANCE;
    }

    public @UnknownKeyFor @NonNull @Initialized StringSetData addAll(String ... strings) {
        HashSet<String> combined = this.stringSet() instanceof HashSet ? (HashSet<String>)this.stringSet() : new HashSet<String>(this.stringSet());
        long stringSize = StringSetData.addUntilCapacity(combined, this.stringSize(), Arrays.asList(strings));
        return StringSetData.createInPlace(combined, stringSize);
    }

    public @UnknownKeyFor @NonNull @Initialized StringSetData combine(@UnknownKeyFor @NonNull @Initialized StringSetData other) {
        if (this.stringSet().isEmpty()) {
            return other;
        }
        if (other.stringSet().isEmpty()) {
            return this;
        }
        HashSet<String> combined = new HashSet<String>(this.stringSet());
        long stringSize = StringSetData.addUntilCapacity(combined, this.stringSize(), other.stringSet());
        return StringSetData.createInPlace(combined, stringSize);
    }

    public @UnknownKeyFor @NonNull @Initialized StringSetData combine(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized StringSetData> others) {
        HashSet<String> combined = new HashSet<String>(this.stringSet());
        long stringSize = this.stringSize();
        for (StringSetData other : others) {
            stringSize = StringSetData.addUntilCapacity(combined, stringSize, other.stringSet());
        }
        return StringSetData.createInPlace(combined, stringSize);
    }

    public @UnknownKeyFor @NonNull @Initialized StringSetResult extractResult() {
        return StringSetResult.create(this.stringSet());
    }

    private static @UnknownKeyFor @NonNull @Initialized long addUntilCapacity(@UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> combined, @UnknownKeyFor @NonNull @Initialized long currentSize, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> others) {
        if (currentSize > 1000000L) {
            return currentSize;
        }
        for (String string : others) {
            if (!combined.add(string) || (currentSize += (long)string.length()) <= 1000000L) continue;
            LOG.warn("StringSet metrics reaches capacity. Further incoming elements won't be recorded. Current size: {}, last element size: {}.", (Object)currentSize, (Object)string.length());
            break;
        }
        return currentSize;
    }

    public static class EmptyStringSetData
    extends StringSetData {
        private static final @UnknownKeyFor @NonNull @Initialized EmptyStringSetData INSTANCE = new EmptyStringSetData();

        private EmptyStringSetData() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> stringSet() {
            return ImmutableSet.of();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long stringSize() {
            return 0L;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StringSetResult extractResult() {
            return StringSetResult.empty();
        }
    }
}

