/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.HashMap;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DistributionData;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.GaugeData;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MonitoringInfoEncodings;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.SpecMonitoringInfoValidator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleMonitoringInfoBuilder {
    private final boolean validateAndDropInvalid;
    private static final HashMap<String, MetricsApi.MonitoringInfoSpec> specs = new HashMap();
    private MetricsApi.MonitoringInfo.Builder builder;
    private SpecMonitoringInfoValidator validator = new SpecMonitoringInfoValidator();

    public SimpleMonitoringInfoBuilder() {
        this(true);
    }

    public SimpleMonitoringInfoBuilder(boolean validateAndDropInvalid) {
        this.builder = MetricsApi.MonitoringInfo.newBuilder();
        this.validateAndDropInvalid = validateAndDropInvalid;
    }

    public SimpleMonitoringInfoBuilder setUrn(String urn) {
        this.builder.setUrn(urn);
        return this;
    }

    public SimpleMonitoringInfoBuilder setType(String type) {
        this.builder.setType(type);
        return this;
    }

    public SimpleMonitoringInfoBuilder setInt64SumValue(long value) {
        this.builder.setPayload(MonitoringInfoEncodings.encodeInt64Counter(value));
        this.builder.setType("beam:metrics:sum_int64:v1");
        return this;
    }

    public SimpleMonitoringInfoBuilder setDoubleSumValue(double value) {
        this.builder.setPayload(MonitoringInfoEncodings.encodeDoubleCounter(value));
        this.builder.setType("beam:metrics:sum_double:v1");
        return this;
    }

    public SimpleMonitoringInfoBuilder setInt64LatestValue(GaugeData data) {
        Preconditions.checkArgument((GaugeData.empty() != data ? 1 : 0) != 0, (Object)"Cannot encode empty gauge data");
        this.builder.setPayload(MonitoringInfoEncodings.encodeInt64Gauge(data));
        this.builder.setType("beam:metrics:latest_int64:v1");
        return this;
    }

    public SimpleMonitoringInfoBuilder setInt64DistributionValue(DistributionData data) {
        this.builder.setPayload(MonitoringInfoEncodings.encodeInt64Distribution(data));
        this.builder.setType("beam:metrics:distribution_int64:v1");
        return this;
    }

    public SimpleMonitoringInfoBuilder setDoubleDistributionValue(long count, double sum, double min, double max) {
        this.builder.setPayload(MonitoringInfoEncodings.encodeDoubleDistribution(count, sum, min, max));
        this.builder.setType("beam:metrics:distribution_double:v1");
        return this;
    }

    public SimpleMonitoringInfoBuilder setLabel(String labelName, String labelValue) {
        this.builder.putLabels(labelName, labelValue);
        return this;
    }

    public void clear() {
        this.builder = MetricsApi.MonitoringInfo.newBuilder();
    }

    public void merge(MetricsApi.MonitoringInfo monitoringInfo) {
        this.builder.mergeFrom(monitoringInfo);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable MetricsApi.MonitoringInfo build() {
        MetricsApi.MonitoringInfo result = this.builder.build();
        if (this.validateAndDropInvalid && this.validator.validate(result).isPresent()) {
            return null;
        }
        return result;
    }

    static {
        for (MetricsApi.MonitoringInfoSpecs.Enum val : MetricsApi.MonitoringInfoSpecs.Enum.values()) {
            if (val.name().equals("UNRECOGNIZED")) continue;
            MetricsApi.MonitoringInfoSpec spec = (MetricsApi.MonitoringInfoSpec)val.getValueDescriptor().getOptions().getExtension(MetricsApi.monitoringInfoSpec);
            specs.put(spec.getUrn(), spec);
        }
    }
}

