/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.direct_java.runners.core.construction.CoderTranslator;
import org.apache.beam.repackaged.direct_java.runners.core.construction.CoderTranslatorRegistrar;
import org.apache.beam.repackaged.direct_java.runners.core.construction.CoderTranslators;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ModelCoders;
import org.apache.beam.repackaged.direct_java.runners.core.construction.Timer;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;

public class ModelCoderRegistrar
implements CoderTranslatorRegistrar {
    @VisibleForTesting
    static final BiMap<Class<? extends Coder>, String> BEAM_MODEL_CODER_URNS = ImmutableBiMap.builder().put(ByteArrayCoder.class, (Object)ModelCoders.BYTES_CODER_URN).put(BooleanCoder.class, (Object)ModelCoders.BOOL_CODER_URN).put(StringUtf8Coder.class, (Object)ModelCoders.STRING_UTF8_CODER_URN).put(KvCoder.class, (Object)ModelCoders.KV_CODER_URN).put(VarLongCoder.class, (Object)ModelCoders.INT64_CODER_URN).put(IntervalWindow.IntervalWindowCoder.class, (Object)ModelCoders.INTERVAL_WINDOW_CODER_URN).put(IterableCoder.class, (Object)ModelCoders.ITERABLE_CODER_URN).put(Timer.Coder.class, (Object)ModelCoders.TIMER_CODER_URN).put(LengthPrefixCoder.class, (Object)ModelCoders.LENGTH_PREFIX_CODER_URN).put(GlobalWindow.Coder.class, (Object)ModelCoders.GLOBAL_WINDOW_CODER_URN).put(WindowedValue.FullWindowedValueCoder.class, (Object)ModelCoders.WINDOWED_VALUE_CODER_URN).put(WindowedValue.ParamWindowedValueCoder.class, (Object)ModelCoders.PARAM_WINDOWED_VALUE_CODER_URN).put(DoubleCoder.class, (Object)ModelCoders.DOUBLE_CODER_URN).put(RowCoder.class, (Object)ModelCoders.ROW_CODER_URN).build();
    public static final Set<String> WELL_KNOWN_CODER_URNS = BEAM_MODEL_CODER_URNS.values();
    @VisibleForTesting
    static final Map<Class<? extends Coder>, CoderTranslator<? extends Coder>> BEAM_MODEL_CODERS = ImmutableMap.builder().put(ByteArrayCoder.class, CoderTranslators.atomic(ByteArrayCoder.class)).put(BooleanCoder.class, CoderTranslators.atomic(BooleanCoder.class)).put(StringUtf8Coder.class, CoderTranslators.atomic(StringUtf8Coder.class)).put(VarLongCoder.class, CoderTranslators.atomic(VarLongCoder.class)).put(IntervalWindow.IntervalWindowCoder.class, CoderTranslators.atomic(IntervalWindow.IntervalWindowCoder.class)).put(GlobalWindow.Coder.class, CoderTranslators.atomic(GlobalWindow.Coder.class)).put(KvCoder.class, CoderTranslators.kv()).put(IterableCoder.class, CoderTranslators.iterable()).put(Timer.Coder.class, CoderTranslators.timer()).put(LengthPrefixCoder.class, CoderTranslators.lengthPrefix()).put(WindowedValue.FullWindowedValueCoder.class, CoderTranslators.fullWindowedValue()).put(WindowedValue.ParamWindowedValueCoder.class, CoderTranslators.paramWindowedValue()).put(DoubleCoder.class, CoderTranslators.atomic(DoubleCoder.class)).put(RowCoder.class, CoderTranslators.row()).build();

    public static boolean isKnownCoder(Coder<?> coder) {
        return BEAM_MODEL_CODER_URNS.containsKey(coder.getClass());
    }

    @Override
    public Map<Class<? extends Coder>, String> getCoderURNs() {
        return BEAM_MODEL_CODER_URNS;
    }

    @Override
    public Map<Class<? extends Coder>, CoderTranslator<? extends Coder>> getCoderTranslators() {
        return BEAM_MODEL_CODERS;
    }

    static {
        Preconditions.checkState((boolean)BEAM_MODEL_CODERS.keySet().containsAll(BEAM_MODEL_CODER_URNS.keySet()), (String)"Every Model %s must have an associated %s. Missing: %s", (Object)Coder.class.getSimpleName(), (Object)CoderTranslator.class.getSimpleName(), (Object)Sets.difference((Set)BEAM_MODEL_CODER_URNS.keySet(), BEAM_MODEL_CODERS.keySet()));
        Preconditions.checkState((boolean)Sets.symmetricDifference(ModelCoders.urns(), Collections.singleton("beam:coder:state_backed_iterable:v1")).equals((Object)BEAM_MODEL_CODER_URNS.values()), (String)"All Model %ss should have an associated java %s", (Object)Coder.class.getSimpleName(), (Object)Coder.class.getSimpleName());
    }
}

