/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.CounterCell;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DistributionCell;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DistributionData;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.GaugeCell;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricCell;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricUpdates;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricsMap;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MonitoringInfoEncodings;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsContainerImpl
implements Serializable,
MetricsContainer {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsContainerImpl.class);
    private final @Nullable String stepName;
    private MetricsMap<MetricName, CounterCell> counters = new MetricsMap<MetricName, CounterCell>(CounterCell::new);
    private MetricsMap<MetricName, DistributionCell> distributions = new MetricsMap<MetricName, DistributionCell>(DistributionCell::new);
    private MetricsMap<MetricName, GaugeCell> gauges = new MetricsMap<MetricName, GaugeCell>(GaugeCell::new);

    public MetricsContainerImpl(@Nullable String stepName) {
        this.stepName = stepName;
    }

    public void reset() {
        this.reset(this.counters);
        this.reset(this.distributions);
        this.reset(this.gauges);
    }

    private void reset(MetricsMap<MetricName, ? extends MetricCell<?>> cells) {
        for (MetricCell<?> cell : cells.values()) {
            cell.reset();
        }
    }

    public CounterCell getCounter(MetricName metricName) {
        return this.counters.get(metricName);
    }

    public @Nullable CounterCell tryGetCounter(MetricName metricName) {
        return this.counters.tryGet(metricName);
    }

    public DistributionCell getDistribution(MetricName metricName) {
        return this.distributions.get(metricName);
    }

    public @Nullable DistributionCell tryGetDistribution(MetricName metricName) {
        return this.distributions.tryGet(metricName);
    }

    public GaugeCell getGauge(MetricName metricName) {
        return this.gauges.get(metricName);
    }

    public @Nullable GaugeCell tryGetGauge(MetricName metricName) {
        return this.gauges.tryGet(metricName);
    }

    private <UpdateT, CellT extends MetricCell<UpdateT>> ImmutableList<MetricUpdates.MetricUpdate<UpdateT>> extractUpdates(MetricsMap<MetricName, CellT> cells) {
        ImmutableList.Builder updates = ImmutableList.builder();
        for (Map.Entry<MetricName, CellT> cell : cells.entries()) {
            if (!((MetricCell)cell.getValue()).getDirty().beforeCommit()) continue;
            updates.add(MetricUpdates.MetricUpdate.create(MetricKey.create((String)this.stepName, (MetricName)cell.getKey()), ((MetricCell)cell.getValue()).getCumulative()));
        }
        return updates.build();
    }

    public MetricUpdates getUpdates() {
        return MetricUpdates.create(this.extractUpdates(this.counters), this.extractUpdates(this.distributions), this.extractUpdates(this.gauges));
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable MetricsApi.MonitoringInfo counterUpdateToMonitoringInfo(MetricUpdates.MetricUpdate<Long> metricUpdate) {
        SimpleMonitoringInfoBuilder builder = new SimpleMonitoringInfoBuilder(true);
        MetricName metricName = metricUpdate.getKey().metricName();
        if (metricName instanceof MonitoringInfoMetricName) {
            MonitoringInfoMetricName monitoringInfoName = (MonitoringInfoMetricName)metricName;
            builder.setUrn(monitoringInfoName.getUrn());
            for (Map.Entry<String, String> e : monitoringInfoName.getLabels().entrySet()) {
                builder.setLabel(e.getKey(), e.getValue());
            }
        } else {
            if (this.stepName == null) {
                return null;
            }
            builder.setUrn(MonitoringInfoConstants.Urns.USER_SUM_INT64).setLabel("NAMESPACE", metricUpdate.getKey().metricName().getNamespace()).setLabel("NAME", metricUpdate.getKey().metricName().getName()).setLabel("PTRANSFORM", metricUpdate.getKey().stepName());
        }
        builder.setInt64SumValue(metricUpdate.getUpdate());
        return builder.build();
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable MetricsApi.MonitoringInfo distributionUpdateToMonitoringInfo(MetricUpdates.MetricUpdate<DistributionData> metricUpdate) {
        SimpleMonitoringInfoBuilder builder = new SimpleMonitoringInfoBuilder(true);
        MetricName metricName = metricUpdate.getKey().metricName();
        if (metricName instanceof MonitoringInfoMetricName) {
            MonitoringInfoMetricName monitoringInfoName = (MonitoringInfoMetricName)metricName;
            builder.setUrn(monitoringInfoName.getUrn());
            for (Map.Entry<String, String> e : monitoringInfoName.getLabels().entrySet()) {
                builder.setLabel(e.getKey(), e.getValue());
            }
        } else {
            builder.setUrn(MonitoringInfoConstants.Urns.USER_DISTRIBUTION_INT64).setLabel("NAMESPACE", metricUpdate.getKey().metricName().getNamespace()).setLabel("NAME", metricUpdate.getKey().metricName().getName());
            if (this.stepName == null) {
                return null;
            }
            builder.setLabel("PTRANSFORM", metricUpdate.getKey().stepName());
        }
        builder.setInt64DistributionValue(metricUpdate.getUpdate());
        return builder.build();
    }

    public Iterable<MetricsApi.MonitoringInfo> getMonitoringInfos() {
        MetricsApi.MonitoringInfo mi;
        ArrayList<MetricsApi.MonitoringInfo> monitoringInfos = new ArrayList<MetricsApi.MonitoringInfo>();
        MetricUpdates metricUpdates = this.getUpdates();
        for (MetricUpdates.MetricUpdate<Long> metricUpdate : metricUpdates.counterUpdates()) {
            mi = this.counterUpdateToMonitoringInfo(metricUpdate);
            if (mi == null) continue;
            monitoringInfos.add(mi);
        }
        for (MetricUpdates.MetricUpdate<Serializable> metricUpdate : metricUpdates.distributionUpdates()) {
            mi = this.distributionUpdateToMonitoringInfo(metricUpdate);
            if (mi == null) continue;
            monitoringInfos.add(mi);
        }
        return monitoringInfos;
    }

    private void commitUpdates(MetricsMap<MetricName, ? extends MetricCell<?>> cells) {
        for (MetricCell<?> cell : cells.values()) {
            cell.getDirty().afterCommit();
        }
    }

    public void commitUpdates() {
        this.commitUpdates(this.counters);
        this.commitUpdates(this.distributions);
        this.commitUpdates(this.gauges);
    }

    private <UserT extends Metric, UpdateT, CellT extends MetricCell<UpdateT>> ImmutableList<MetricUpdates.MetricUpdate<UpdateT>> extractCumulatives(MetricsMap<MetricName, CellT> cells) {
        ImmutableList.Builder updates = ImmutableList.builder();
        for (Map.Entry<MetricName, CellT> cell : cells.entries()) {
            Object update = Preconditions.checkNotNull(((MetricCell)cell.getValue()).getCumulative());
            updates.add(MetricUpdates.MetricUpdate.create(MetricKey.create((String)this.stepName, (MetricName)cell.getKey()), update));
        }
        return updates.build();
    }

    public MetricUpdates getCumulative() {
        return MetricUpdates.create(this.extractCumulatives(this.counters), this.extractCumulatives(this.distributions), this.extractCumulatives(this.gauges));
    }

    public void update(MetricsContainerImpl other) {
        this.updateCounters(this.counters, other.counters);
        this.updateDistributions(this.distributions, other.distributions);
        this.updateGauges(this.gauges, other.gauges);
    }

    private void updateForSumInt64Type(MetricsApi.MonitoringInfo monitoringInfo) {
        MonitoringInfoMetricName metricName = MonitoringInfoMetricName.of(monitoringInfo);
        CounterCell counter = this.getCounter(metricName);
        counter.inc(MonitoringInfoEncodings.decodeInt64Counter(monitoringInfo.getPayload()));
    }

    private void updateForDistributionInt64Type(MetricsApi.MonitoringInfo monitoringInfo) {
        MonitoringInfoMetricName metricName = MonitoringInfoMetricName.of(monitoringInfo);
        DistributionCell distribution = this.getDistribution(metricName);
        DistributionData data = MonitoringInfoEncodings.decodeInt64Distribution(monitoringInfo.getPayload());
        distribution.update(data.sum(), data.count(), data.min(), data.max());
    }

    private void updateForLatestInt64Type(MetricsApi.MonitoringInfo monitoringInfo) {
        MonitoringInfoMetricName metricName = MonitoringInfoMetricName.of(monitoringInfo);
        GaugeCell gauge = this.getGauge(metricName);
        gauge.update(MonitoringInfoEncodings.decodeInt64Gauge(monitoringInfo.getPayload()));
    }

    public void update(Iterable<MetricsApi.MonitoringInfo> monitoringInfos) {
        block10: for (MetricsApi.MonitoringInfo monitoringInfo : monitoringInfos) {
            if (monitoringInfo.getPayload().isEmpty()) {
                return;
            }
            switch (monitoringInfo.getType()) {
                case "beam:metrics:sum_int64:v1": {
                    this.updateForSumInt64Type(monitoringInfo);
                    continue block10;
                }
                case "beam:metrics:distribution_int64:v1": {
                    this.updateForDistributionInt64Type(monitoringInfo);
                    continue block10;
                }
                case "beam:metrics:latest_int64:v1": {
                    this.updateForLatestInt64Type(monitoringInfo);
                    continue block10;
                }
            }
            LOG.warn("Unsupported metric type {}", (Object)monitoringInfo.getType());
        }
    }

    private void updateCounters(MetricsMap<MetricName, CounterCell> current, MetricsMap<MetricName, CounterCell> updates) {
        for (Map.Entry<MetricName, CounterCell> counter : updates.entries()) {
            current.get(counter.getKey()).inc(counter.getValue().getCumulative());
        }
    }

    private void updateDistributions(MetricsMap<MetricName, DistributionCell> current, MetricsMap<MetricName, DistributionCell> updates) {
        for (Map.Entry<MetricName, DistributionCell> counter : updates.entries()) {
            current.get(counter.getKey()).update(counter.getValue().getCumulative());
        }
    }

    private void updateGauges(MetricsMap<MetricName, GaugeCell> current, MetricsMap<MetricName, GaugeCell> updates) {
        for (Map.Entry<MetricName, GaugeCell> counter : updates.entries()) {
            current.get(counter.getKey()).update(counter.getValue().getCumulative());
        }
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof MetricsContainerImpl) {
            MetricsContainerImpl metricsContainerImpl = (MetricsContainerImpl)object;
            return Objects.equals(this.stepName, metricsContainerImpl.stepName) && Objects.equals(this.counters, metricsContainerImpl.counters) && Objects.equals(this.distributions, metricsContainerImpl.distributions) && Objects.equals(this.gauges, metricsContainerImpl.gauges);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.stepName, this.counters, this.distributions, this.gauges);
    }
}

