/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class ExecutableTriggerStateMachine
implements Serializable {
    private final int triggerIndex;
    private final int firstIndexAfterSubtree;
    private final List<ExecutableTriggerStateMachine> subTriggers = new ArrayList<ExecutableTriggerStateMachine>();
    private final TriggerStateMachine trigger;

    public static <W extends BoundedWindow> ExecutableTriggerStateMachine create(TriggerStateMachine trigger) {
        return ExecutableTriggerStateMachine.create(trigger, 0);
    }

    private static <W extends BoundedWindow> ExecutableTriggerStateMachine create(TriggerStateMachine trigger, int nextUnusedIndex) {
        return new ExecutableTriggerStateMachine(trigger, nextUnusedIndex);
    }

    public static <W extends BoundedWindow> ExecutableTriggerStateMachine createForOnceTrigger(TriggerStateMachine trigger, int nextUnusedIndex) {
        return new ExecutableTriggerStateMachine(trigger, nextUnusedIndex);
    }

    private ExecutableTriggerStateMachine(TriggerStateMachine trigger, int nextUnusedIndex) {
        this.trigger = (TriggerStateMachine)Preconditions.checkNotNull((Object)trigger, (Object)"trigger must not be null");
        this.triggerIndex = nextUnusedIndex++;
        if (trigger.subTriggers() != null) {
            for (TriggerStateMachine subTrigger : trigger.subTriggers()) {
                ExecutableTriggerStateMachine subExecutable = ExecutableTriggerStateMachine.create(subTrigger, nextUnusedIndex);
                this.subTriggers.add(subExecutable);
                nextUnusedIndex = subExecutable.firstIndexAfterSubtree;
            }
        }
        this.firstIndexAfterSubtree = nextUnusedIndex;
    }

    public List<ExecutableTriggerStateMachine> subTriggers() {
        return this.subTriggers;
    }

    public String toString() {
        return this.trigger.toString();
    }

    public TriggerStateMachine getSpec() {
        return this.trigger;
    }

    public int getTriggerIndex() {
        return this.triggerIndex;
    }

    public final int getFirstIndexAfterSubtree() {
        return this.firstIndexAfterSubtree;
    }

    public boolean isCompatible(ExecutableTriggerStateMachine other) {
        return this.trigger.isCompatible(other.trigger);
    }

    public ExecutableTriggerStateMachine getSubTriggerContaining(int index) {
        Preconditions.checkNotNull(this.subTriggers);
        Preconditions.checkState((index > this.triggerIndex && index < this.firstIndexAfterSubtree ? 1 : 0) != 0, (Object)"Cannot find sub-trigger containing index not in this tree.");
        ExecutableTriggerStateMachine previous = null;
        for (ExecutableTriggerStateMachine subTrigger : this.subTriggers) {
            if (index < subTrigger.triggerIndex) {
                return previous;
            }
            previous = subTrigger;
        }
        return previous;
    }

    public void invokeOnElement(TriggerStateMachine.OnElementContext c) throws Exception {
        this.trigger.onElement(c.forTrigger(this));
    }

    public void invokeOnMerge(TriggerStateMachine.OnMergeContext c) throws Exception {
        TriggerStateMachine.OnMergeContext subContext = c.forTrigger(this);
        this.trigger.onMerge(subContext);
    }

    public boolean invokeShouldFire(TriggerStateMachine.TriggerContext c) throws Exception {
        return this.trigger.shouldFire(c.forTrigger(this));
    }

    public void invokeOnFire(TriggerStateMachine.TriggerContext c) throws Exception {
        this.trigger.onFire(c.forTrigger(this));
    }

    public void invokeClear(TriggerStateMachine.TriggerContext c) throws Exception {
        this.trigger.clear(c.forTrigger(this));
    }
}

