/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.CoderTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.Environments;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PCollectionTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.PTransformTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class SdkComponents {
    private final String newIdPrefix;
    private final RunnerApi.Components.Builder componentsBuilder = RunnerApi.Components.newBuilder();
    private final BiMap<AppliedPTransform<?, ?, ?>, String> transformIds = HashBiMap.create();
    private final BiMap<PCollection<?>, String> pCollectionIds = HashBiMap.create();
    private final BiMap<WindowingStrategy<?, ?>, String> windowingStrategyIds = HashBiMap.create();
    private final BiMap<Coder<?>, String> coderIds = HashBiMap.create();
    private final BiMap<RunnerApi.Environment, String> environmentIds = HashBiMap.create();
    private final Set<String> requirements;
    private final Set<String> reservedIds = new HashSet<String>();
    private String defaultEnvironmentId;

    public static SdkComponents create() {
        return new SdkComponents(RunnerApi.Components.getDefaultInstance(), null, "");
    }

    public static SdkComponents create(RunnerApi.Components components, Collection<String> requirements) {
        return new SdkComponents(components, requirements, "");
    }

    static SdkComponents create(RunnerApi.Components components, Map<String, AppliedPTransform<?, ?, ?>> transforms, Map<String, PCollection<?>> pCollections, Map<String, WindowingStrategy<?, ?>> windowingStrategies, Map<String, Coder<?>> coders, Map<String, RunnerApi.Environment> environments, Collection<String> requirements) {
        SdkComponents sdkComponents = SdkComponents.create(components, requirements);
        sdkComponents.transformIds.inverse().putAll(transforms);
        sdkComponents.pCollectionIds.inverse().putAll(pCollections);
        sdkComponents.windowingStrategyIds.inverse().putAll(windowingStrategies);
        sdkComponents.coderIds.inverse().putAll(coders);
        sdkComponents.environmentIds.inverse().putAll(environments);
        return sdkComponents;
    }

    public static SdkComponents create(PipelineOptions options) {
        SdkComponents sdkComponents = new SdkComponents(RunnerApi.Components.getDefaultInstance(), null, "");
        PortablePipelineOptions portablePipelineOptions = (PortablePipelineOptions)options.as(PortablePipelineOptions.class);
        sdkComponents.registerEnvironment(Environments.createOrGetDefaultEnvironment(portablePipelineOptions));
        return sdkComponents;
    }

    private SdkComponents(@Nullable RunnerApi.Components components, @Nullable Collection<String> requirements, String newIdPrefix) {
        this.newIdPrefix = newIdPrefix;
        this.requirements = new HashSet<String>();
        if (components == null) {
            if (requirements != null) {
                this.requirements.addAll(requirements);
            }
        } else {
            this.mergeFrom(components, requirements);
        }
    }

    public void mergeFrom(RunnerApi.Components components, @Nullable Collection<String> requirements) {
        this.reservedIds.addAll(components.getTransformsMap().keySet());
        this.reservedIds.addAll(components.getPcollectionsMap().keySet());
        this.reservedIds.addAll(components.getWindowingStrategiesMap().keySet());
        this.reservedIds.addAll(components.getCodersMap().keySet());
        this.reservedIds.addAll(components.getEnvironmentsMap().keySet());
        components.getEnvironmentsMap().forEach((arg_0, arg_1) -> ((BiMap)this.environmentIds.inverse()).forcePut(arg_0, arg_1));
        if (requirements != null) {
            this.requirements.addAll(requirements);
        }
        this.componentsBuilder.mergeFrom(components);
    }

    public SdkComponents withNewIdPrefix(String newIdPrefix) {
        SdkComponents sdkComponents = new SdkComponents(this.componentsBuilder.build(), this.requirements, newIdPrefix);
        sdkComponents.transformIds.putAll(this.transformIds);
        sdkComponents.pCollectionIds.putAll(this.pCollectionIds);
        sdkComponents.windowingStrategyIds.putAll(this.windowingStrategyIds);
        sdkComponents.coderIds.putAll(this.coderIds);
        sdkComponents.environmentIds.putAll(this.environmentIds);
        return sdkComponents;
    }

    public String registerPTransform(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> children) throws IOException {
        String name = this.getApplicationName(appliedPTransform);
        if (this.componentsBuilder.getTransformsOrDefault(name, null) != null) {
            return name;
        }
        Preconditions.checkNotNull(children, (Object)"child nodes may not be null");
        this.componentsBuilder.putTransforms(name, PTransformTranslation.toProto(appliedPTransform, children, this));
        return name;
    }

    private String getApplicationName(AppliedPTransform<?, ?, ?> appliedPTransform) {
        String existing = (String)this.transformIds.get(appliedPTransform);
        if (existing != null) {
            return existing;
        }
        String name = appliedPTransform.getFullName();
        if (name.isEmpty()) {
            name = "unnamed-ptransform";
        }
        name = this.uniqify(name, this.transformIds.values());
        this.transformIds.put(appliedPTransform, (Object)name);
        return name;
    }

    String getExistingPTransformId(AppliedPTransform<?, ?, ?> appliedPTransform) {
        Preconditions.checkArgument((boolean)this.transformIds.containsKey(appliedPTransform), (String)"%s %s has not been previously registered", (Object)AppliedPTransform.class.getSimpleName(), appliedPTransform);
        return (String)this.transformIds.get(appliedPTransform);
    }

    public String getPTransformIdOrThrow(AppliedPTransform<?, ?, ?> appliedPTransform) {
        String existing = (String)this.transformIds.get(appliedPTransform);
        Preconditions.checkArgument((existing != null ? 1 : 0) != 0, (String)"PTransform id not found for: %s", appliedPTransform);
        return existing;
    }

    public String registerPCollection(PCollection<?> pCollection) throws IOException {
        String existing = (String)this.pCollectionIds.get(pCollection);
        if (existing != null) {
            return existing;
        }
        String uniqueName = this.uniqify(pCollection.getName(), this.pCollectionIds.values());
        this.pCollectionIds.put(pCollection, (Object)uniqueName);
        this.componentsBuilder.putPcollections(uniqueName, PCollectionTranslation.toProto(pCollection, this));
        return uniqueName;
    }

    public String registerWindowingStrategy(WindowingStrategy<?, ?> windowingStrategy) throws IOException {
        String existing = (String)this.windowingStrategyIds.get(windowingStrategy);
        if (existing != null) {
            return existing;
        }
        String baseName = String.format("%s(%s)", NameUtils.approximateSimpleName(windowingStrategy), NameUtils.approximateSimpleName((Object)windowingStrategy.getWindowFn()));
        String name = this.uniqify(baseName, this.windowingStrategyIds.values());
        this.windowingStrategyIds.put(windowingStrategy, (Object)name);
        RunnerApi.WindowingStrategy windowingStrategyProto = WindowingStrategyTranslation.toProto(windowingStrategy, this);
        this.componentsBuilder.putWindowingStrategies(name, windowingStrategyProto);
        return name;
    }

    public String registerCoder(Coder<?> coder) throws IOException {
        String existing = (String)this.coderIds.get(coder);
        if (existing != null) {
            return existing;
        }
        String baseName = NameUtils.approximateSimpleName(coder);
        String name = this.uniqify(baseName, this.coderIds.values());
        this.coderIds.put(coder, (Object)name);
        RunnerApi.Coder coderProto = CoderTranslation.toProto(coder, this);
        this.componentsBuilder.putCoders(name, coderProto);
        return name;
    }

    public String registerEnvironment(RunnerApi.Environment env) {
        String environmentId;
        String existing = (String)this.environmentIds.get((Object)env);
        if (existing != null) {
            environmentId = existing;
        } else {
            String name = this.uniqify(env.getUrn(), this.environmentIds.values());
            this.environmentIds.put((Object)env, (Object)name);
            this.componentsBuilder.putEnvironments(name, env);
            environmentId = name;
        }
        if (this.defaultEnvironmentId == null) {
            this.defaultEnvironmentId = environmentId;
        }
        return environmentId;
    }

    public String getOnlyEnvironmentId() {
        if (this.defaultEnvironmentId != null) {
            return this.defaultEnvironmentId;
        }
        return (String)Iterables.getOnlyElement(this.componentsBuilder.getEnvironmentsMap().keySet());
    }

    public void addRequirement(String urn) {
        this.requirements.add(urn);
    }

    private String uniqify(String baseName, Set<String> existing) {
        String name = this.newIdPrefix + baseName;
        int increment = 1;
        while (existing.contains(name) || this.reservedIds.contains(name)) {
            name = this.newIdPrefix + baseName + Integer.toString(increment);
            ++increment;
        }
        return name;
    }

    public RunnerApi.Components toComponents() {
        return this.componentsBuilder.build();
    }

    public Collection<String> requirements() {
        return ImmutableSet.copyOf(this.requirements);
    }
}

