/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.triggers;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Joiner;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.runners.direct.repackaged.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.direct.repackaged.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.annotations.Experimental;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterAllStateMachine
extends TriggerStateMachine.OnceTriggerStateMachine {
    private AfterAllStateMachine(List<TriggerStateMachine> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    @SafeVarargs
    public static TriggerStateMachine.OnceTriggerStateMachine of(TriggerStateMachine ... triggers) {
        return new AfterAllStateMachine(Arrays.asList(triggers));
    }

    public static TriggerStateMachine.OnceTriggerStateMachine of(Iterable<? extends TriggerStateMachine> triggers) {
        return new AfterAllStateMachine(ImmutableList.copyOf(triggers));
    }

    @Override
    public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().unfinishedSubTriggers()) {
            subTrigger.invokeOnElement(c);
        }
    }

    @Override
    public void onMerge(TriggerStateMachine.OnMergeContext c) throws Exception {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokeOnMerge(c);
        }
        boolean allFinished = true;
        for (ExecutableTriggerStateMachine subTrigger1 : c.trigger().subTriggers()) {
            allFinished &= c.forTrigger(subTrigger1).trigger().isFinished();
        }
        c.trigger().setFinished(allFinished);
    }

    @Override
    public boolean shouldFire(TriggerStateMachine.TriggerContext context) throws Exception {
        for (ExecutableTriggerStateMachine subtrigger : context.trigger().subTriggers()) {
            if (context.forTrigger(subtrigger).trigger().isFinished() || subtrigger.invokeShouldFire(context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onOnlyFiring(TriggerStateMachine.TriggerContext context) throws Exception {
        for (ExecutableTriggerStateMachine subtrigger : context.trigger().subTriggers()) {
            subtrigger.invokeOnFire(context);
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterAll.of(");
        Joiner.on(", ").appendTo(builder, (Iterable<?>)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }
}

