/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.metrics;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.annotations.Experimental;

@Experimental(value=Experimental.Kind.METRICS)
class DirtyState
implements Serializable {
    private final AtomicReference<State> dirty = new AtomicReference<State>(State.DIRTY);

    DirtyState() {
    }

    public void afterModification() {
        this.dirty.set(State.DIRTY);
    }

    public boolean beforeCommit() {
        State state;
        while ((state = this.dirty.get()) != State.CLEAN && !this.dirty.compareAndSet(state, State.COMMITTING)) {
        }
        return state != State.CLEAN;
    }

    public void afterCommit() {
        this.dirty.compareAndSet(State.COMMITTING, State.CLEAN);
    }

    private static enum State {
        DIRTY,
        CLEAN,
        COMMITTING;

    }
}

