/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.metrics;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.DirtyState;
import org.apache.beam.runners.direct.repackaged.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.MetricName;

@Experimental(value=Experimental.Kind.METRICS)
public class CounterCell
implements Counter,
MetricCell<Long> {
    private final DirtyState dirty = new DirtyState();
    private final AtomicLong value = new AtomicLong();
    private final MetricName name;

    CounterCell(MetricName name) {
        this.name = name;
    }

    public void inc(long n) {
        this.value.addAndGet(n);
        this.dirty.afterModification();
    }

    public void inc() {
        this.inc(1L);
    }

    public void dec() {
        this.inc(-1L);
    }

    public void dec(long n) {
        this.inc(-1L * n);
    }

    @Override
    public DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public Long getCumulative() {
        return this.value.get();
    }

    public MetricName getName() {
        return this.name;
    }
}

