/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.SdkComponents;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.runners.direct.repackaged.sdk.common.runner.v1.RunnerApi;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

public class PTransforms {
    private static final Map<Class<? extends PTransform>, TransformPayloadTranslator> KNOWN_PAYLOAD_TRANSLATORS = ImmutableMap.builder().build();

    private PTransforms() {
    }

    static RunnerApi.PTransform toProto(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> subtransforms, SdkComponents components) throws IOException {
        RunnerApi.PTransform.Builder transformBuilder = RunnerApi.PTransform.newBuilder();
        for (Map.Entry entry : appliedPTransform.getInputs().entrySet()) {
            Preconditions.checkArgument(entry.getValue() instanceof PCollection, "Unexpected input type %s", ((PValue)entry.getValue()).getClass());
            transformBuilder.putInputs(PTransforms.toProto((TupleTag)entry.getKey()), components.registerPCollection((PCollection)entry.getValue()));
        }
        for (Map.Entry entry : appliedPTransform.getOutputs().entrySet()) {
            Preconditions.checkArgument(entry.getValue() instanceof PCollection, "Unexpected output type %s", ((PValue)entry.getValue()).getClass());
            transformBuilder.putOutputs(PTransforms.toProto((TupleTag)entry.getKey()), components.registerPCollection((PCollection)entry.getValue()));
        }
        for (AppliedPTransform appliedPTransform2 : subtransforms) {
            transformBuilder.addSubtransforms(components.getExistingPTransformId(appliedPTransform2));
        }
        transformBuilder.setUniqueName(appliedPTransform.getFullName());
        PTransform transform = appliedPTransform.getTransform();
        if (KNOWN_PAYLOAD_TRANSLATORS.containsKey(transform.getClass())) {
            RunnerApi.FunctionSpec functionSpec = KNOWN_PAYLOAD_TRANSLATORS.get(transform.getClass()).translate(appliedPTransform, components);
            transformBuilder.setSpec(functionSpec);
        }
        return transformBuilder.build();
    }

    private static String toProto(TupleTag<?> tag) {
        return tag.getId();
    }

    public static interface TransformPayloadTranslator<T extends PTransform<?, ?>> {
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, T> var1, SdkComponents var2);
    }
}

