/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core.construction;

import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.direct.repackaged.runners.core.construction.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;

public class PTransformReplacements {
    public static <T> PCollection<T> getSingletonMainInput(AppliedPTransform<? extends PCollection<? extends T>, ?, ?> application) {
        return PTransformReplacements.getSingletonMainInput(application.getInputs(), application.getTransform().getAdditionalInputs().keySet());
    }

    private static <T> PCollection<T> getSingletonMainInput(Map<TupleTag<?>, PValue> inputs, Set<TupleTag<?>> ignoredTags) {
        PCollection mainInput = null;
        for (Map.Entry<TupleTag<?>, PValue> input : inputs.entrySet()) {
            if (ignoredTags.contains(input.getKey())) continue;
            Preconditions.checkArgument(mainInput == null, "Got multiple inputs that are not additional inputs for a singleton main input: %s and %s", mainInput, (Object)input.getValue());
            Preconditions.checkArgument(input.getValue() instanceof PCollection, "Unexpected input type %s", input.getValue().getClass());
            mainInput = (PCollection)input.getValue();
        }
        Preconditions.checkArgument(mainInput != null, "No main input found in inputs: Inputs %s, Side Input tags %s", inputs, ignoredTags);
        return mainInput;
    }
}

