/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.runners.direct.repackaged.runners.core.ElementAndRestriction;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;

@Experimental(value=Experimental.Kind.SPLITTABLE_DO_FN)
public class ElementAndRestrictionCoder<ElementT, RestrictionT>
extends StructuredCoder<ElementAndRestriction<ElementT, RestrictionT>> {
    private final Coder<ElementT> elementCoder;
    private final Coder<RestrictionT> restrictionCoder;

    public static <ElementT, RestrictionT> ElementAndRestrictionCoder<ElementT, RestrictionT> of(Coder<ElementT> elementCoder, Coder<RestrictionT> restrictionCoder) {
        return new ElementAndRestrictionCoder<ElementT, RestrictionT>(elementCoder, restrictionCoder);
    }

    private ElementAndRestrictionCoder(Coder<ElementT> elementCoder, Coder<RestrictionT> restrictionCoder) {
        this.elementCoder = elementCoder;
        this.restrictionCoder = restrictionCoder;
    }

    public void encode(ElementAndRestriction<ElementT, RestrictionT> value, OutputStream outStream) throws IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null ElementAndRestriction");
        }
        this.elementCoder.encode(value.element(), outStream);
        this.restrictionCoder.encode(value.restriction(), outStream);
    }

    public ElementAndRestriction<ElementT, RestrictionT> decode(InputStream inStream) throws IOException {
        Object key = this.elementCoder.decode(inStream);
        Object value = this.restrictionCoder.decode(inStream);
        return ElementAndRestriction.of(key, value);
    }

    public List<? extends Coder<?>> getCoderArguments() {
        return ImmutableList.of(this.elementCoder, this.restrictionCoder);
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.elementCoder.verifyDeterministic();
        this.restrictionCoder.verifyDeterministic();
    }

    public Coder<ElementT> getElementCoder() {
        return this.elementCoder;
    }

    public Coder<RestrictionT> getRestrictionCoder() {
        return this.restrictionCoder;
    }
}

