/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.beam.runners.direct.repackaged.runners.core.ExecutionContext;
import org.apache.beam.runners.direct.repackaged.runners.core.StateInternals;
import org.apache.beam.runners.direct.repackaged.runners.core.TimerInternals;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.TupleTag;

public abstract class BaseExecutionContext<T extends ExecutionContext.StepContext>
implements ExecutionContext {
    private Map<String, T> cachedStepContexts = new LinkedHashMap<String, T>();

    protected abstract T createStepContext(String var1, String var2);

    public T getOrCreateStepContext(String stepName, String transformName) {
        final String finalStepName = stepName;
        final String finalTransformName = transformName;
        return this.getOrCreateStepContext(stepName, new CreateStepContextFunction<T>(){

            @Override
            public T create() {
                return BaseExecutionContext.this.createStepContext(finalStepName, finalTransformName);
            }
        });
    }

    protected final T getOrCreateStepContext(String stepName, CreateStepContextFunction<T> createContextFunc) {
        ExecutionContext.StepContext context = (ExecutionContext.StepContext)this.cachedStepContexts.get(stepName);
        if (context == null) {
            context = createContextFunc.create();
            this.cachedStepContexts.put(stepName, context);
        }
        return (T)context;
    }

    public Collection<? extends T> getAllStepContexts() {
        return Collections.unmodifiableCollection(this.cachedStepContexts.values());
    }

    @Override
    public void noteOutput(WindowedValue<?> output) {
    }

    @Override
    public void noteOutput(TupleTag<?> tag, WindowedValue<?> output) {
    }

    public static abstract class StepContext
    implements ExecutionContext.StepContext {
        private final ExecutionContext executionContext;
        private final String stepName;
        private final String transformName;

        public StepContext(ExecutionContext executionContext, String stepName, String transformName) {
            this.executionContext = executionContext;
            this.stepName = stepName;
            this.transformName = transformName;
        }

        @Override
        public String getStepName() {
            return this.stepName;
        }

        @Override
        public String getTransformName() {
            return this.transformName;
        }

        @Override
        public void noteOutput(WindowedValue<?> output) {
            this.executionContext.noteOutput(output);
        }

        @Override
        public void noteOutput(TupleTag<?> tag, WindowedValue<?> output) {
            this.executionContext.noteOutput(tag, output);
        }

        @Override
        public <T, W extends BoundedWindow> void writePCollectionViewData(TupleTag<?> tag, Iterable<WindowedValue<T>> data, Coder<Iterable<WindowedValue<T>>> dataCoder, W window, Coder<W> windowCoder) throws IOException {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public abstract StateInternals stateInternals();

        @Override
        public abstract TimerInternals timerInternals();
    }

    protected static interface CreateStepContextFunction<T extends ExecutionContext.StepContext> {
        public T create();
    }
}

