/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct.repackaged.runners.core;

import java.util.Collection;
import org.apache.beam.runners.direct.repackaged.runners.core.OldDoFn;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.runners.core.java.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.SystemDoFnInternal;
import org.joda.time.Instant;

@SystemDoFnInternal
public class AssignWindowsDoFn<T, W extends BoundedWindow>
extends OldDoFn<T, T>
implements OldDoFn.RequiresWindowAccess {
    private WindowFn<? super T, W> fn;

    public AssignWindowsDoFn(WindowFn<? super T, W> fn) {
        this.fn = Preconditions.checkNotNull(fn, "%s provided to %s cannot be null", (Object)WindowFn.class.getSimpleName(), (Object)AssignWindowsDoFn.class.getSimpleName());
    }

    @Override
    public void processElement(final OldDoFn.ProcessContext c) throws Exception {
        WindowFn<T, W> windowFn = this.fn;
        windowFn.getClass();
        Collection windows = this.fn.assignWindows(new WindowFn.AssignContext(windowFn){

            public T element() {
                return c.element();
            }

            public Instant timestamp() {
                return c.timestamp();
            }

            public BoundedWindow window() {
                return Iterables.getOnlyElement(c.windowingInternals().windows());
            }
        });
        c.windowingInternals().outputWindowedValue(c.element(), c.timestamp(), windows, PaneInfo.NO_FIRING);
    }
}

