/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.beam.runners.direct.BundleFactory;
import org.apache.beam.runners.direct.Clock;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.CommittedResult;
import org.apache.beam.runners.direct.CopyOnAccessInMemoryStateInternals;
import org.apache.beam.runners.direct.DirectExecutionContext;
import org.apache.beam.runners.direct.DirectGraph;
import org.apache.beam.runners.direct.DirectMetrics;
import org.apache.beam.runners.direct.DirectOptions;
import org.apache.beam.runners.direct.PCollectionViewWriter;
import org.apache.beam.runners.direct.SideInputContainer;
import org.apache.beam.runners.direct.StepAndKey;
import org.apache.beam.runners.direct.StructuralKey;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.UncommittedBundle;
import org.apache.beam.runners.direct.WatermarkCallbackExecutor;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.runners.direct.repackaged.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.runners.direct.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.Iterables;
import org.apache.beam.runners.direct.repackaged.com.google.common.util.concurrent.MoreExecutors;
import org.apache.beam.runners.direct.repackaged.javax.annotation.Nullable;
import org.apache.beam.runners.direct.repackaged.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.direct.repackaged.runners.core.TimerInternals;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class EvaluationContext {
    private final DirectGraph graph;
    private final DirectOptions options;
    private final Clock clock;
    private final BundleFactory bundleFactory;
    private final WatermarkManager watermarkManager;
    private final WatermarkCallbackExecutor callbackExecutor;
    private final ConcurrentMap<StepAndKey, CopyOnAccessInMemoryStateInternals> applicationStateInternals;
    private final SideInputContainer sideInputContainer;
    private final DirectMetrics metrics;
    private final Set<PValue> keyedPValues;

    public static EvaluationContext create(DirectOptions options, Clock clock, BundleFactory bundleFactory, DirectGraph graph, Set<PValue> keyedPValues) {
        return new EvaluationContext(options, clock, bundleFactory, graph, keyedPValues);
    }

    private EvaluationContext(DirectOptions options, Clock clock, BundleFactory bundleFactory, DirectGraph graph, Set<PValue> keyedPValues) {
        this.options = Preconditions.checkNotNull(options);
        this.clock = clock;
        this.bundleFactory = Preconditions.checkNotNull(bundleFactory);
        this.graph = Preconditions.checkNotNull(graph);
        this.keyedPValues = keyedPValues;
        this.watermarkManager = WatermarkManager.create(clock, graph);
        this.sideInputContainer = SideInputContainer.create(this, graph.getViews());
        this.applicationStateInternals = new ConcurrentHashMap<StepAndKey, CopyOnAccessInMemoryStateInternals>();
        this.metrics = new DirectMetrics();
        this.callbackExecutor = WatermarkCallbackExecutor.create(MoreExecutors.directExecutor());
    }

    public void initialize(Map<AppliedPTransform<?, ?, ?>, ? extends Iterable<CommittedBundle<?>>> initialInputs) {
        this.watermarkManager.initialize(initialInputs);
    }

    public CommittedResult handleResult(@Nullable CommittedBundle<?> completedBundle, Iterable<TimerInternals.TimerData> completedTimers, TransformResult<?> result) {
        Iterable<? extends CommittedBundle<?>> committedBundles = this.commitBundles(result.getOutputBundles());
        this.metrics.commitLogical(completedBundle, result.getLogicalMetricUpdates());
        EnumSet<CommittedResult.OutputType> outputTypes = EnumSet.copyOf(result.getOutputTypes());
        if (Iterables.isEmpty(committedBundles)) {
            outputTypes.remove((Object)CommittedResult.OutputType.BUNDLE);
        } else {
            outputTypes.add(CommittedResult.OutputType.BUNDLE);
        }
        CommittedResult committedResult = CommittedResult.create(result, completedBundle == null ? null : completedBundle.withElements(result.getUnprocessedElements()), committedBundles, outputTypes);
        CopyOnAccessInMemoryStateInternals theirState = result.getState();
        if (theirState != null) {
            CopyOnAccessInMemoryStateInternals committedState = theirState.commit();
            StepAndKey stepAndKey = StepAndKey.of(result.getTransform(), completedBundle == null ? null : completedBundle.getKey());
            if (!committedState.isEmpty()) {
                this.applicationStateInternals.put(stepAndKey, committedState);
            } else {
                this.applicationStateInternals.remove(stepAndKey);
            }
        }
        this.watermarkManager.updateWatermarks(completedBundle, result.getTimerUpdate().withCompletedTimers(completedTimers), committedResult, result.getWatermarkHold());
        return committedResult;
    }

    private Iterable<? extends CommittedBundle<?>> commitBundles(Iterable<? extends UncommittedBundle<?>> bundles) {
        ImmutableList.Builder completed = ImmutableList.builder();
        for (UncommittedBundle<?> inProgress : bundles) {
            AppliedPTransform<?, ?, ?> producing;
            WatermarkManager.TransformWatermarks watermarks;
            CommittedBundle<?> committed = inProgress.commit((watermarks = this.watermarkManager.getWatermarks(producing = this.graph.getProducer((PValue)inProgress.getPCollection()))).getSynchronizedProcessingOutputTime());
            if (Iterables.isEmpty(committed.getElements())) continue;
            completed.add(committed);
        }
        return completed.build();
    }

    private void fireAllAvailableCallbacks() {
        for (AppliedPTransform<?, ?, ?> transform : this.graph.getPrimitiveTransforms()) {
            this.fireAvailableCallbacks(transform);
        }
    }

    private void fireAvailableCallbacks(AppliedPTransform<?, ?, ?> producingTransform) {
        WatermarkManager.TransformWatermarks watermarks = this.watermarkManager.getWatermarks(producingTransform);
        Instant outputWatermark = watermarks.getOutputWatermark();
        this.callbackExecutor.fireForWatermark(producingTransform, outputWatermark);
    }

    public <T> UncommittedBundle<T> createRootBundle() {
        return this.bundleFactory.createRootBundle();
    }

    public <T> UncommittedBundle<T> createBundle(PCollection<T> output) {
        return this.bundleFactory.createBundle(output);
    }

    public <K, T> UncommittedBundle<T> createKeyedBundle(StructuralKey<K> key, PCollection<T> output) {
        return this.bundleFactory.createKeyedBundle(key, output);
    }

    public <T> boolean isKeyed(PValue pValue) {
        return this.keyedPValues.contains(pValue);
    }

    public <ElemT, ViewT> PCollectionViewWriter<ElemT, ViewT> createPCollectionViewWriter(PCollection<Iterable<ElemT>> input, final PCollectionView<ViewT> output) {
        return new PCollectionViewWriter<ElemT, ViewT>(){

            @Override
            public void add(Iterable<WindowedValue<ElemT>> values) {
                EvaluationContext.this.sideInputContainer.write(output, values);
            }
        };
    }

    public void scheduleAfterOutputWouldBeProduced(PValue value, BoundedWindow window, WindowingStrategy<?, ?> windowingStrategy, Runnable runnable) {
        AppliedPTransform<?, ?, ?> producing = this.graph.getProducer(value);
        this.callbackExecutor.callOnGuaranteedFiring(producing, window, windowingStrategy, runnable);
        this.fireAvailableCallbacks(producing);
    }

    public void scheduleAfterWindowExpiration(AppliedPTransform<?, ?, ?> producing, BoundedWindow window, WindowingStrategy<?, ?> windowingStrategy, Runnable runnable) {
        this.callbackExecutor.callOnWindowExpiration(producing, window, windowingStrategy, runnable);
        this.fireAvailableCallbacks(producing);
    }

    public DirectOptions getPipelineOptions() {
        return this.options;
    }

    public DirectExecutionContext getExecutionContext(AppliedPTransform<?, ?, ?> application, StructuralKey<?> key) {
        StepAndKey stepAndKey = StepAndKey.of(application, key);
        return new DirectExecutionContext(this.clock, key, (CopyOnAccessInMemoryStateInternals)this.applicationStateInternals.get(stepAndKey), this.watermarkManager.getWatermarks(application));
    }

    String getStepName(AppliedPTransform<?, ?, ?> application) {
        return this.graph.getStepName(application);
    }

    Collection<AppliedPTransform<?, ?, ?>> getSteps() {
        return this.graph.getPrimitiveTransforms();
    }

    public ReadyCheckingSideInputReader createSideInputReader(List<PCollectionView<?>> sideInputs) {
        return this.sideInputContainer.createReaderForViews(sideInputs);
    }

    public DirectMetrics getMetrics() {
        return this.metrics;
    }

    @VisibleForTesting
    void forceRefresh() {
        this.watermarkManager.refreshAll();
        this.fireAllAvailableCallbacks();
    }

    public Collection<WatermarkManager.FiredTimers> extractFiredTimers() {
        this.forceRefresh();
        return this.watermarkManager.extractFiredTimers();
    }

    public boolean isDone(AppliedPTransform<?, ?, ?> transform) {
        Instant stepWatermark = this.watermarkManager.getWatermarks(transform).getOutputWatermark();
        return !stepWatermark.isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE);
    }

    public boolean isDone() {
        for (AppliedPTransform<?, ?, ?> transform : this.graph.getPrimitiveTransforms()) {
            if (this.isDone(transform)) continue;
            return false;
        }
        return true;
    }

    public Instant now() {
        return this.clock.now();
    }

    Clock getClock() {
        return this.clock;
    }
}

