/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.direct.repackaged.com.google.common.collect.ListMultimap;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;

class DirectGraph {
    private final Map<POutput, AppliedPTransform<?, ?, ?>> producers;
    private final ListMultimap<PInput, AppliedPTransform<?, ?, ?>> primitiveConsumers;
    private final Set<PCollectionView<?>> views;
    private final Set<AppliedPTransform<?, ?, ?>> rootTransforms;
    private final Map<AppliedPTransform<?, ?, ?>, String> stepNames;

    public static DirectGraph create(Map<POutput, AppliedPTransform<?, ?, ?>> producers, ListMultimap<PInput, AppliedPTransform<?, ?, ?>> primitiveConsumers, Set<PCollectionView<?>> views, Set<AppliedPTransform<?, ?, ?>> rootTransforms, Map<AppliedPTransform<?, ?, ?>, String> stepNames) {
        return new DirectGraph(producers, primitiveConsumers, views, rootTransforms, stepNames);
    }

    private DirectGraph(Map<POutput, AppliedPTransform<?, ?, ?>> producers, ListMultimap<PInput, AppliedPTransform<?, ?, ?>> primitiveConsumers, Set<PCollectionView<?>> views, Set<AppliedPTransform<?, ?, ?>> rootTransforms, Map<AppliedPTransform<?, ?, ?>, String> stepNames) {
        this.producers = producers;
        this.primitiveConsumers = primitiveConsumers;
        this.views = views;
        this.rootTransforms = rootTransforms;
        this.stepNames = stepNames;
    }

    AppliedPTransform<?, ?, ?> getProducer(PValue produced) {
        return this.producers.get(produced);
    }

    List<AppliedPTransform<?, ?, ?>> getPrimitiveConsumers(PValue consumed) {
        return this.primitiveConsumers.get((PInput)consumed);
    }

    Set<AppliedPTransform<?, ?, ?>> getRootTransforms() {
        return this.rootTransforms;
    }

    Set<PCollectionView<?>> getViews() {
        return this.views;
    }

    String getStepName(AppliedPTransform<?, ?, ?> step) {
        return this.stepNames.get(step);
    }

    Collection<AppliedPTransform<?, ?, ?>> getPrimitiveTransforms() {
        return this.stepNames.keySet();
    }
}

