/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.batchee.servlet.JBatchController;

public class JBatchServletInitializer
implements ServletContainerInitializer {
    public static final String ACTIVE = "org.apache.batchee.servlet.active";
    public static final String CONTROLLER_MAPPING = "org.apache.batchee.servlet.mapping";
    public static final String ACTIVE_PRIVATE_FILTER = "org.apache.batchee.servlet.filter.private";
    public static final String BY_PAGE = "org.apache.batchee.servlet.pagination";
    private static final String DEFAULT_MAPPING = "/jbatch/*";

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        String active = ctx.getInitParameter(ACTIVE);
        if (active != null && !Boolean.parseBoolean(active)) {
            return;
        }
        String mapping = ctx.getInitParameter(CONTROLLER_MAPPING);
        if (mapping == null) {
            mapping = DEFAULT_MAPPING;
        } else if (!mapping.endsWith("/*")) {
            mapping = mapping + "/*";
        }
        String byPage = ctx.getInitParameter(BY_PAGE);
        byPage = byPage == null ? "30" : byPage + byPage;
        ctx.addServlet("JBatch Servlet", (Servlet)new JBatchController().readOnly(JBatchServletInitializer.isReadOnly(ctx.getClassLoader())).mapping(mapping).executionByPage(Integer.parseInt(byPage))).addMapping(new String[]{mapping});
        String activePrivateFilter = ctx.getInitParameter(ACTIVE_PRIVATE_FILTER);
        if (activePrivateFilter == null || Boolean.parseBoolean(activePrivateFilter)) {
            ctx.addFilter("JBatch Private Filter", PrivateFilter.class).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        }
    }

    private static boolean isReadOnly(ClassLoader classLoader) {
        try {
            return Collections.list(classLoader.getResources("META-INF/batch-jobs")).isEmpty();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static class PrivateFilter
    implements Filter {
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest httpServletRequest;
            String requestURI;
            if (HttpServletRequest.class.isInstance(request) && HttpServletResponse.class.isInstance(response) && (requestURI = (httpServletRequest = (HttpServletRequest)HttpServletRequest.class.cast(request)).getRequestURI()).contains("/internal/batchee") && requestURI.endsWith("jsp")) {
                ((HttpServletResponse)HttpServletResponse.class.cast(response)).sendError(404);
                return;
            }
            chain.doFilter(request, response);
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void destroy() {
        }
    }
}

