/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.jsonp;

import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemWriter;
import javax.batch.operations.BatchRuntimeException;
import javax.inject.Inject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.transaction.TransactionalWriter;

@Documentation(value="Write a JSON file using JSON-P and taking JsonStructure as items.")
public class JsonpWriter
implements ItemWriter {
    @Inject
    @BatchProperty
    @Documentation(value="output file")
    private String file;
    @Inject
    @BatchProperty
    @Documentation(value="output encoding")
    private String encoding;
    @Inject
    @BatchProperty
    @Documentation(value="comma separated key value pairs for the generator factory (converted to a Map<?, ?>)")
    private String configuration;
    @Inject
    @BatchProperty
    @Documentation(value="is the array wrapped in an object or not")
    private String skipRoot;
    @Inject
    @BatchProperty
    @Documentation(value="how to generate field names for each item, default uses item1, item2, ...")
    private String fieldNameGeneratorClass;
    @Inject
    @BatchProperty
    @Documentation(value="JSON-P provider if not using the default")
    private String provider;
    private JsonGenerator generator;
    private TransactionalWriter writer;
    private FieldNameGenerator fieldNameGenerator = null;

    public void open(Serializable checkpoint) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        JsonProvider provider = this.provider == null ? JsonProvider.provider() : (JsonProvider)JsonProvider.class.cast(loader.loadClass(this.provider));
        File outputFile = new File(this.file);
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            throw new BatchRuntimeException("Can't create " + outputFile.getAbsolutePath());
        }
        this.writer = new TransactionalWriter(outputFile, this.encoding, checkpoint);
        this.generator = provider.createGeneratorFactory(this.buildConfig()).createGenerator((Writer)this.writer);
        if (this.fieldNameGeneratorClass != null) {
            this.fieldNameGenerator = "default".equals(this.fieldNameGeneratorClass) ? new FieldNameGenerator(){
                private int count = 0;

                @Override
                public String nextName() {
                    return "item" + ++this.count;
                }
            } : (FieldNameGenerator)FieldNameGenerator.class.cast(Thread.currentThread().getContextClassLoader().loadClass(this.fieldNameGeneratorClass).newInstance());
        }
        if (this.useGlobalWrapper()) {
            if (this.fieldNameGenerator != null) {
                this.generator.writeStartObject();
            } else {
                this.generator.writeStartArray();
            }
        }
    }

    private Map<String, ?> buildConfig() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.configuration != null) {
            for (String entry : this.configuration.trim().split(" *, *")) {
                String[] parts = entry.split(" *= *");
                if (parts.length != 2) {
                    throw new IllegalArgumentException(entry + " not matching a=b pattern");
                }
                map.put(parts[0], parts[1]);
            }
        }
        return map;
    }

    public void close() throws Exception {
        if (this.generator != null) {
            if (this.useGlobalWrapper()) {
                this.generator.writeEnd();
            }
            this.generator.close();
        }
    }

    public void writeItems(List<Object> items) throws Exception {
        List structures = (List)List.class.cast(items);
        for (JsonStructure structure : structures) {
            if (this.fieldNameGenerator != null) {
                this.generator.write(this.fieldNameGenerator.nextName(), (JsonValue)structure);
                continue;
            }
            this.generator.write((JsonValue)structure);
        }
        this.writer.flush();
    }

    public Serializable checkpointInfo() throws Exception {
        return Long.valueOf(this.writer.position());
    }

    private boolean useGlobalWrapper() {
        return this.skipRoot == null || !"true".equalsIgnoreCase(this.skipRoot);
    }

    public static interface FieldNameGenerator {
        public String nextName();
    }
}

