/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller;

import javax.batch.runtime.context.JobContext;
import org.apache.batchee.container.jsl.CloneUtility;
import org.apache.batchee.jaxb.Flow;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.jaxb.ObjectFactory;
import org.apache.batchee.jaxb.Partition;
import org.apache.batchee.jaxb.PartitionPlan;
import org.apache.batchee.jaxb.Split;
import org.apache.batchee.jaxb.Step;

public class PartitionedStepBuilder {
    public static final String JOB_ID_SEPARATOR = ":";

    private PartitionedStepBuilder() {
    }

    public static JSLJob buildFlowInSplitSubJob(Long parentJobExecutionId, JobContext jobContext, Split split, Flow flow) {
        ObjectFactory jslFactory = new ObjectFactory();
        JSLJob subJob = jslFactory.createJSLJob();
        String subJobId = PartitionedStepBuilder.generateSubJobId(parentJobExecutionId, split.getId(), flow.getId());
        subJob.setId(subJobId);
        subJob.setProperties(CloneUtility.javaPropsTojslProperties(jobContext.getProperties()));
        subJob.getExecutionElements().add(flow);
        return subJob;
    }

    public static JSLJob buildPartitionSubJob(Long parentJobInstanceId, JobContext jobContext, Step step, int partitionInstance) {
        Partition partition;
        ObjectFactory jslFactory = new ObjectFactory();
        JSLJob subJob = jslFactory.createJSLJob();
        String subJobId = PartitionedStepBuilder.generateSubJobId(parentJobInstanceId, step.getId(), partitionInstance);
        subJob.setId(subJobId);
        subJob.setProperties(CloneUtility.javaPropsTojslProperties(jobContext.getProperties()));
        Step newStep = jslFactory.createStep();
        newStep.setId(step.getId());
        newStep.setAllowStartIfComplete(step.getAllowStartIfComplete());
        if (step.getBatchlet() != null) {
            newStep.setBatchlet(CloneUtility.cloneBatchlet(step.getBatchlet()));
        }
        if (step.getChunk() != null) {
            newStep.setChunk(CloneUtility.cloneChunk(step.getChunk()));
        }
        if ((partition = step.getPartition()) != null && partition.getCollector() != null) {
            Partition basePartition = jslFactory.createPartition();
            PartitionPlan partitionPlan = jslFactory.createPartitionPlan();
            partitionPlan.setPartitions(null);
            basePartition.setPlan(partitionPlan);
            basePartition.setCollector(partition.getCollector());
            newStep.setPartition(basePartition);
        }
        newStep.setStartLimit(step.getStartLimit());
        newStep.setProperties(CloneUtility.cloneJSLProperties(step.getProperties()));
        newStep.setListeners(CloneUtility.cloneListeners(step.getListeners()));
        subJob.getExecutionElements().add(newStep);
        return subJob;
    }

    private static String generateSubJobId(Long parentJobInstanceId, String splitId, String flowId) {
        return JOB_ID_SEPARATOR + parentJobInstanceId.toString() + JOB_ID_SEPARATOR + splitId + JOB_ID_SEPARATOR + flowId;
    }

    private static String generateSubJobId(Long parentJobInstanceId, String stepId, int partitionInstance) {
        return JOB_ID_SEPARATOR + parentJobInstanceId.toString() + JOB_ID_SEPARATOR + stepId + JOB_ID_SEPARATOR + partitionInstance;
    }
}

