/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.factory;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamReader;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.proxy.ProxyFactory;
import org.apache.batchee.container.util.DependencyInjections;
import org.apache.batchee.spi.BatchArtifactFactory;

public class DefaultBatchArtifactFactory
implements BatchArtifactFactory,
XMLStreamConstants {
    private static final String BATCH_XML = "META-INF/batch.xml";
    private static final String BATCHEE_XML = "META-INF/batchee.xml";
    private static final QName BATCH_ROOT_ELEM = new QName("http://xmlns.jcp.org/xml/ns/javaee", "batch-artifacts");

    @Override
    public BatchArtifactFactory.Instance load(String batchId) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        ArtifactLocator artifactMap = this.createArtifactsLocator(tccl);
        Object loadedArtifact = artifactMap.getArtifactById(batchId);
        if (loadedArtifact == null) {
            try {
                Class<?> artifactClass = tccl.loadClass(batchId);
                if (artifactClass != null) {
                    loadedArtifact = artifactClass.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + batchId, e);
            }
            catch (InstantiationException e) {
                throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + batchId, e);
            }
            catch (IllegalAccessException e) {
                throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + batchId, e);
            }
        }
        if (ProxyFactory.getInjectionReferences() != null) {
            DependencyInjections.injectReferences(loadedArtifact, ProxyFactory.getInjectionReferences());
        }
        return new BatchArtifactFactory.Instance(loadedArtifact, null);
    }

    protected ArtifactLocator createArtifactsLocator(ClassLoader tccl) {
        ArtifactMap artifactMap = new ArtifactMap();
        this.initArtifactMapFromClassLoader(artifactMap, tccl, BATCH_XML);
        this.initArtifactMapFromClassLoader(artifactMap, tccl, BATCHEE_XML);
        return artifactMap;
    }

    private ArtifactMap initArtifactMapFromClassLoader(ArtifactMap map, ClassLoader loader, String name) {
        Enumeration<URL> urls;
        try {
            urls = loader.getResources(name);
        }
        catch (IOException e) {
            InputStream is = loader.getResourceAsStream(name);
            if (is == null) {
                return null;
            }
            this.populateArtifactMapFromStream(map, is);
            return map;
        }
        LinkedList<URL> parsedUrls = new LinkedList<URL>();
        while (urls.hasMoreElements()) {
            InputStream is;
            URL url = urls.nextElement();
            if (parsedUrls.contains(url)) continue;
            parsedUrls.add(url);
            try {
                is = url.openStream();
            }
            catch (IOException e) {
                throw new BatchContainerRuntimeException(e);
            }
            this.populateArtifactMapFromStream(map, is);
        }
        return map;
    }

    protected void populateArtifactMapFromStream(ArtifactMap tempMap, InputStream is) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            int event;
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(is);
            boolean processedRoot = false;
            while (xmlStreamReader.hasNext() && (event = xmlStreamReader.next()) != 8) {
                if (event != 1) continue;
                if (!processedRoot) {
                    QName rootQName = xmlStreamReader.getName();
                    if (!rootQName.equals(BATCH_ROOT_ELEM)) {
                        throw new IllegalStateException("Expecting document with root element QName: " + BATCH_ROOT_ELEM + ", but found root element with QName: " + rootQName);
                    }
                    processedRoot = true;
                    continue;
                }
                String annotationShortName = xmlStreamReader.getLocalName();
                String id = xmlStreamReader.getAttributeValue(null, "id");
                String className = xmlStreamReader.getAttributeValue(null, "class");
                tempMap.addEntry(annotationShortName, id, className);
                while (event != 2) {
                    event = xmlStreamReader.next();
                }
            }
            xmlStreamReader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void init(Properties batchConfig) throws BatchContainerServiceException {
    }

    private class ArtifactMap
    implements ArtifactLocator {
        private Map<String, Class<?>> idToArtifactClassMap = new HashMap();
        private Map<String, List<String>> idToArtifactTypeListMap = new HashMap<String, List<String>>();

        private ArtifactMap() {
        }

        private void addEntry(String batchTypeName, String id, String className) {
            try {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                if (!this.idToArtifactClassMap.containsKey(id)) {
                    Class<?> artifactClass = contextClassLoader.loadClass(className);
                    this.idToArtifactClassMap.put(id, artifactClass);
                    ArrayList<String> typeList = new ArrayList<String>();
                    typeList.add(batchTypeName);
                    this.idToArtifactTypeListMap.put(id, typeList);
                } else {
                    Class<?> artifactClass = contextClassLoader.loadClass(className);
                    if (!this.idToArtifactClassMap.get(id).equals(artifactClass)) {
                        throw new IllegalArgumentException("Already loaded a different class for id = " + id);
                    }
                    List<String> typeList = this.idToArtifactTypeListMap.get(id);
                    typeList.add(batchTypeName);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object getArtifactById(String id) {
            Object artifactInstance = null;
            try {
                Class<?> clazz = this.idToArtifactClassMap.get(id);
                if (clazz != null) {
                    artifactInstance = this.idToArtifactClassMap.get(id).newInstance();
                }
            }
            catch (IllegalAccessException e) {
                throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + id, e);
            }
            catch (InstantiationException e) {
                throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + id, e);
            }
            return artifactInstance;
        }
    }

    protected static interface ArtifactLocator {
        public Object getArtifactById(String var1);
    }
}

