/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.hazelcast;

import java.util.concurrent.TimeUnit;
import javax.batch.api.BatchProperty;
import javax.batch.api.Batchlet;
import javax.inject.Inject;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.hazelcast.HazelcastSynchroInstanceAware;

@Documentation(value="Obtain a hazelcast lock")
public class HazelcastLockBatchlet
extends HazelcastSynchroInstanceAware
implements Batchlet {
    @Inject
    @BatchProperty
    @Documentation(value="The duration this task can wait to get the lock")
    protected String tryDuration;
    @Inject
    @BatchProperty
    @Documentation(value="The duration unit associated to tryDuration")
    protected String tryDurationUnit;

    public String process() throws Exception {
        if (this.tryDuration != null) {
            this.findLock().lock(Long.parseLong(this.tryDuration), TimeUnit.valueOf(this.tryDurationUnit()));
        }
        this.findLock().lock();
        return "locked";
    }

    protected String tryDurationUnit() {
        if (this.tryDurationUnit == null) {
            this.tryDurationUnit = TimeUnit.SECONDS.name();
        }
        return this.tryDurationUnit;
    }

    public void stop() throws Exception {
    }
}

