/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.transaction;

import jakarta.batch.operations.BatchRuntimeException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.batchee.extras.transaction.integration.SynchronizationService;
import org.apache.batchee.extras.transaction.integration.Synchronizations;

public class TransactionalWriter
extends Writer {
    private static final String BASE_BUFFER_KEY = TransactionalWriter.class.getName() + ".buffer";
    private final String encoding;
    private final String bufferKey;
    private final FileChannel delegate;
    private long position;
    private boolean closed;

    public TransactionalWriter(File file, String encoding, Serializable checkpoint) throws FileNotFoundException {
        long restartOffset;
        block6: {
            this.position = 0L;
            this.closed = false;
            this.delegate = new RandomAccessFile(file, "rw").getChannel();
            this.bufferKey = BASE_BUFFER_KEY + "." + this.hashCode();
            this.encoding = encoding != null ? encoding : "UTF-8";
            if (checkpoint != null && Number.class.isInstance(checkpoint)) {
                restartOffset = ((Number)Number.class.cast(checkpoint)).longValue();
                try {
                    if (this.delegate.size() < restartOffset) {
                        throw new BatchRuntimeException("File seems too small");
                    }
                    break block6;
                }
                catch (IOException e) {
                    throw new BatchRuntimeException((Throwable)e);
                }
            }
            restartOffset = 0L;
        }
        try {
            this.delegate.truncate(restartOffset);
            this.delegate.position(restartOffset);
        }
        catch (IOException e) {
            throw new BatchRuntimeException((Throwable)e);
        }
        this.position = restartOffset;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (Synchronizations.hasTransaction()) {
            this.buffer().append(cbuf, off, len);
        } else {
            String string = String.valueOf(cbuf, off, off + len);
            if (this.delegate.write(ByteBuffer.wrap(string.getBytes(this.encoding))) != string.length()) {
                throw new IOException("Some data were not written");
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (!Synchronizations.hasTransaction()) {
            this.fileFlush();
        } else {
            this.position = this.delegate.position() + (long)this.buffer().length();
        }
    }

    private void fileFlush() throws IOException {
        this.delegate.force(false);
        this.position = this.delegate.position();
    }

    @Override
    public void close() throws IOException {
        if ((!Synchronizations.hasTransaction() || Synchronizations.get(this.bufferKey) == null) && this.delegate.isOpen()) {
            this.fileFlush();
            this.delegate.close();
        } else {
            this.closed = true;
        }
    }

    public long position() {
        return this.position;
    }

    private StringBuilder buffer() {
        StringBuilder buf = (StringBuilder)StringBuilder.class.cast(Synchronizations.get(this.bufferKey));
        if (buf == null) {
            StringBuilder buffer;
            buf = buffer = new StringBuilder();
            Synchronizations.put(this.bufferKey, buffer);
            Synchronizations.registerSynchronization(new SynchronizationService.OnCommit(){

                @Override
                public void afterCommit() {
                    try {
                        byte[] bytes = buffer.toString().getBytes(TransactionalWriter.this.encoding);
                        if (TransactionalWriter.this.delegate.write(ByteBuffer.wrap(bytes)) != bytes.length) {
                            throw new BatchRuntimeException("Some part of the chunk was not written");
                        }
                        TransactionalWriter.this.delegate.force(false);
                    }
                    catch (IOException ioe) {
                        throw new BatchRuntimeException((Throwable)ioe);
                    }
                    this.close();
                }

                @Override
                public void afterRollback() {
                    this.close();
                }

                private void close() {
                    if (TransactionalWriter.this.closed && TransactionalWriter.this.delegate.isOpen()) {
                        try {
                            TransactionalWriter.this.delegate.close();
                        }
                        catch (IOException e) {
                            throw new BatchRuntimeException((Throwable)e);
                        }
                    }
                }
            });
        }
        return buf;
    }
}

