/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.batch.operations.BatchRuntimeException;
import javax.inject.Inject;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.batchee.doc.api.Documentation;
import org.apache.batchee.extras.stax.util.JAXBContextFactory;
import org.apache.batchee.extras.transaction.CountedReader;

@Documentation(value="Reads XML items using StAX.")
public class StaxItemReader
extends CountedReader
implements ItemReader {
    @Inject
    @BatchProperty
    @Documentation(value="JAXB type(s) to instantiate for items, supports CSV values")
    private String marshallingClasses;
    @Inject
    @BatchProperty
    @Documentation(value="JAXB package if needed (optional)")
    private String marshallingPackage;
    @Inject
    @BatchProperty
    @Documentation(value="Tag to match - others are ignored")
    private String tag;
    @Inject
    @BatchProperty
    @Documentation(value="Input file path")
    private String input;
    private XMLEventReader reader;
    private Unmarshaller unmarshaller;

    @Override
    public void open(Serializable checkpoint) throws Exception {
        if (this.input == null) {
            throw new BatchRuntimeException("input should be set");
        }
        if (this.tag == null) {
            throw new BatchRuntimeException("tag should be set");
        }
        if (this.marshallingPackage == null && this.marshallingClasses == null) {
            throw new BatchRuntimeException("marshallingPackage should be set");
        }
        this.unmarshaller = JAXBContextFactory.getJaxbContext(this.marshallingPackage, this.marshallingClasses).createUnmarshaller();
        InputStream is = this.findInput();
        if (is == null) {
            throw new BatchRuntimeException("Can't find input '" + this.input + "'");
        }
        this.reader = XMLInputFactory.newInstance().createXMLEventReader(is);
        super.open(checkpoint);
    }

    private InputStream findInput() throws FileNotFoundException {
        File file = new File(this.input);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(this.input);
    }

    public void close() throws Exception {
        this.reader.close();
    }

    @Override
    protected Object doRead() throws Exception {
        boolean found = false;
        while (this.reader.hasNext()) {
            try {
                XMLEvent xmlEvent = this.reader.peek();
                if (xmlEvent != null && xmlEvent.isStartElement() && this.tag.equals(xmlEvent.asStartElement().getName().getLocalPart())) {
                    found = true;
                    break;
                }
                this.reader.nextEvent();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
        if (!found) {
            return null;
        }
        try {
            Object jaxbObject = this.unmarshaller.unmarshal(this.reader);
            if (JAXBElement.class.isInstance(jaxbObject)) {
                JAXBElement jbe = (JAXBElement)jaxbObject;
                return ((JAXBElement)JAXBElement.class.cast(jbe)).getValue();
            }
            return jaxbObject;
        }
        catch (JAXBException ue) {
            throw new BatchRuntimeException((Throwable)ue);
        }
    }
}

