/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.extras.validation;

import java.util.Set;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemProcessor;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;

public class BeanValidationItemProcessor
implements ItemProcessor {
    @Inject
    @BatchProperty
    private String group;
    @Inject
    @BatchProperty
    private String skipNotValidated;

    public Object processItem(Object item) throws Exception {
        Validator validator = this.getValidator();
        Set<ConstraintViolation<Object>> result = this.validate(validator, item);
        if (result != null && !result.isEmpty()) {
            if (Boolean.parseBoolean(this.skipNotValidated)) {
                return null;
            }
            throw new ConstraintViolationException((Set)Set.class.cast(result));
        }
        return item;
    }

    private Set<ConstraintViolation<Object>> validate(Validator validator, Object item) throws ClassNotFoundException {
        Set result = this.group == null ? validator.validate(item, new Class[0]) : validator.validate(item, new Class[]{this.loadGroup()});
        return result;
    }

    protected Class<?> loadGroup() throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(this.group);
    }

    protected Validator getValidator() throws NamingException {
        Validator validator;
        try {
            validator = (Validator)Validator.class.cast(new InitialContext().lookup("java:comp/Validator"));
        }
        catch (NamingException nnfe) {
            validator = Validation.buildDefaultValidatorFactory().getValidator();
        }
        return validator;
    }
}

