/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.csv.mapper;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.batchee.csv.CsvReaderMapper;
import org.apache.batchee.csv.CsvWriterMapper;
import org.apache.batchee.csv.mapper.CoercingConverter;
import org.apache.batchee.csv.mapper.Csv;
import org.apache.batchee.csv.mapper.Primitives;
import org.apache.batchee.csv.mapper.XBeanConverter;
import org.apache.commons.csv.CSVRecord;

public class DefaultMapper<T>
implements CsvReaderMapper<T>,
CsvWriterMapper<T> {
    private final Class<T> type;
    private final CoercingConverter coercingConverter;
    private final SortedMap<Integer, Field> fieldByPosition = new TreeMap<Integer, Field>();
    private final SortedMap<String, Field> fieldByName = new TreeMap<String, Field>();
    private final SortedMap<Integer, String> headers = new TreeMap<Integer, String>();
    private final int maxIndex;

    public DefaultMapper(Class<T> type) {
        this(type, DefaultMapper.loadConverter());
    }

    protected DefaultMapper(Class<T> type, CoercingConverter coercingConverter) {
        this.type = type;
        this.coercingConverter = coercingConverter;
        int higherIdx = -1;
        for (Class<T> current = type; current != Object.class; current = current.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Csv csv = field.getAnnotation(Csv.class);
                if (csv == null) continue;
                int pos = csv.index();
                String name = csv.name();
                boolean defaultName = "__DEFAULT__".equals(name);
                if (pos >= 0) {
                    if (this.fieldByPosition.put(pos, field) != null) {
                        throw new IllegalArgumentException("multiple field for index " + pos + " in " + String.valueOf(type));
                    }
                    if (!defaultName) {
                        this.headers.put(pos, name);
                    }
                } else if (!defaultName && this.fieldByName.put(name, field) != null) {
                    throw new IllegalArgumentException("multiple field for name '" + name + "' in " + String.valueOf(type));
                }
                if (pos > higherIdx) {
                    higherIdx = pos;
                }
                if (field.isAccessible()) continue;
                field.setAccessible(true);
            }
        }
        this.maxIndex = higherIdx;
    }

    public Iterable<String> getHeaders() {
        return this.headers.values();
    }

    @Override
    public T fromRecord(CSVRecord record) {
        try {
            Field field;
            String obj;
            T instance = this.type.newInstance();
            for (Map.Entry<Integer, Field> entry : this.fieldByPosition.entrySet()) {
                obj = record.get(entry.getKey().intValue());
                field = entry.getValue();
                this.setField(instance, obj, field);
            }
            for (Map.Entry<Object, Field> entry : this.fieldByName.entrySet()) {
                obj = record.get((String)entry.getKey());
                field = entry.getValue();
                this.setField(instance, obj, field);
            }
            return instance;
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Iterable<String> toRecord(T instance) {
        LinkedList<String> record = new LinkedList<String>();
        for (int i = 0; i < this.maxIndex + 1; ++i) {
            Field f = (Field)this.fieldByPosition.get(i);
            if (f == null) {
                record.add(null);
                continue;
            }
            try {
                Object val = f.get(instance);
                record.add(val == null ? "" : val.toString());
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        return record;
    }

    private void setField(T instance, String obj, Field field) throws IllegalAccessException {
        if (obj != null) {
            field.set(instance, this.convert(field.getType(), obj));
        }
    }

    private Object convert(Class<?> type, String value) {
        Object val;
        if (String.class == type) {
            return value;
        }
        if (this.coercingConverter != null && (val = this.coercingConverter.valueFor(type, value)) != null) {
            return val;
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(type));
    }

    private static CoercingConverter loadConverter() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.apache.xbean.propertyeditor.PropertyEditors");
            return XBeanConverter.INSTANCE;
        }
        catch (ClassNotFoundException e) {
            return Primitives.INSTANCE;
        }
    }
}

