/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.lifecycle.impl;

import jakarta.ejb.embeddable.EJBContainer;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.InitialContext;
import org.apache.batchee.cli.classloader.ChildFirstURLClassLoader;
import org.apache.batchee.cli.lifecycle.impl.LifecycleBase;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.spi.BatchThreadPoolService;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.core.LocalInitialContext;
import org.apache.openejb.core.LocalInitialContextFactory;
import org.apache.openejb.loader.SystemInstance;

public class OpenEJBLifecycle
extends LifecycleBase<Object> {
    private Assembler assembler = null;
    private AppInfo info = null;
    private AtomicBoolean running = new AtomicBoolean(false);

    @Override
    public Object start() {
        File app;
        Map<String, Object> config = this.configuration("openejb");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (ChildFirstURLClassLoader.class.isInstance(loader) && (app = ((ChildFirstURLClassLoader)ChildFirstURLClassLoader.class.cast(loader)).getApplicationFolder()) != null) {
            if (new File(app, "WEB-INF").exists()) {
                ConcurrentHashMap<String, Object> configuration = new ConcurrentHashMap<String, Object>(config);
                configuration.putIfAbsent("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
                configuration.putIfAbsent("openejb.embedded.initialcontext.close", LocalInitialContext.Close.DESTROY.name());
                configuration.putIfAbsent("openejb.deployments.classpath", "false");
                try {
                    LocalInitialContextFactory.class.getClassLoader().loadClass("org.apache.openejb.server.ServiceManager");
                    configuration.putIfAbsent("openejb.embedded.remotable", "true");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Properties props = new Properties();
                props.putAll((Map<?, ?>)configuration);
                try {
                    InitialContext initialContext = new InitialContext(props);
                    AppModule appModule = new DeploymentLoader().load(app);
                    this.info = new ConfigurationFactory().configureApplication(appModule);
                    this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
                    this.assembler.createApplication(this.info, loader);
                    this.running.set(true);
                    return initialContext;
                }
                catch (Exception e) {
                    throw new BatchContainerRuntimeException((Throwable)e);
                }
            }
            throw new BatchContainerRuntimeException("bar not supported by OpenEJB, use a war please");
        }
        return EJBContainer.createEJBContainer(config);
    }

    @Override
    public void stop(Object state) {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        BatchThreadPoolService threadPoolService = (BatchThreadPoolService)ServicesManager.find().service(BatchThreadPoolService.class);
        threadPoolService.shutdown();
        if (state != null) {
            if (this.assembler != null && this.info != null) {
                try {
                    this.assembler.destroyApplication(this.info);
                }
                catch (UndeployException e) {
                    throw new BatchContainerRuntimeException((Throwable)e);
                }
            }
            try {
                state.getClass().getMethod("close", new Class[0]).invoke(state, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        EJBContainer.createEJBContainer();
    }
}

