/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import jakarta.batch.operations.JobOperator;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.StepExecution;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.batchee.cli.command.JobOperatorCommand;
import org.apache.batchee.cli.command.api.Command;
import org.apache.batchee.cli.command.api.Option;
import org.apache.commons.lang3.StringUtils;

@Command(name="stepExecutions", description="list step executions for a particular execution")
public class StepExecutions
extends JobOperatorCommand {
    @Option(name="id", description="execution id", required=true)
    private long id;

    public StepExecutions withId(long id) {
        this.id = id;
        return this;
    }

    public StepExecutions withOperator(JobOperator operator) {
        this.operator = operator;
        return this;
    }

    @Override
    public void doRun() {
        JobOperator operator = this.operator();
        List executions = operator.getStepExecutions(this.id);
        if (executions == null || executions.isEmpty()) {
            this.info("Executions of " + this.id + " not found");
            return;
        }
        this.info("Step executions of " + this.id);
        ArrayList<Metric.MetricType> metricsOrder = new ArrayList<Metric.MetricType>();
        StringBuilder metrics = new StringBuilder();
        for (Metric.MetricType type : Metric.MetricType.values()) {
            metrics.append("\t|\t").append(type.name());
            metricsOrder.add(type);
        }
        SimpleDateFormat format = new SimpleDateFormat("YYYYMMdd hh:mm:ss");
        this.info("   step id\t|\t step name\t|\t    start time   \t|\t     end time    \t|\texit status\t|\tbatch status" + metrics.toString());
        for (StepExecution exec : executions) {
            StringBuilder builder = new StringBuilder(String.format("%10d\t|\t%s\t|\t%s\t|\t%s\t|\t%s\t|\t%s", exec.getStepExecutionId(), StringUtils.center((String)exec.getStepName(), (int)10), format.format(exec.getStartTime()), exec.getEndTime() != null ? format.format(exec.getEndTime()) : "-", StringUtils.center((String)(exec.getExitStatus() == null ? "-" : exec.getExitStatus()), (int)11), StringUtils.center((String)String.valueOf(exec.getBatchStatus()), (int)12)));
            HashMap<Metric.MetricType, Long> stepMetrics = new HashMap<Metric.MetricType, Long>();
            if (exec.getMetrics() != null) {
                for (Metric m : exec.getMetrics()) {
                    stepMetrics.put(m.getType(), m.getValue());
                }
            }
            for (Metric.MetricType type : metricsOrder) {
                Long value = (Long)stepMetrics.get(type);
                builder.append("\t|\t");
                if (value != null) {
                    builder.append(StringUtils.center((String)Long.toString(value), (int)type.name().length()));
                    continue;
                }
                builder.append("-");
            }
            this.info(builder.toString());
        }
    }
}

