/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.batchee.cli.command.JobOperatorCommand;
import org.apache.batchee.cli.command.api.Command;

@Command(name="names", description="list known batches")
public class Names
extends JobOperatorCommand {
    private static final Pattern JOB_XML_PATTERN = Pattern.compile("META-INF/batch-jobs/(.*)\\.xml");

    @Override
    public void doRun() {
        Enumeration<URL> resources;
        Set names = this.operator().getJobNames();
        this.info("");
        this.info("names");
        this.info("-----");
        if (names != null) {
            for (String name : names) {
                this.info(name);
            }
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            resources = loader.getResources("META-INF/batch-jobs");
        }
        catch (IOException e) {
            return;
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            File file = Names.toFile(url);
            if (file == null) continue;
            if (file.isDirectory()) {
                this.findInDirectory(file);
                continue;
            }
            this.findInJar(file);
        }
        this.info("-----");
    }

    private void findInJar(File file) {
        JarFile jar;
        try {
            jar = new JarFile(file);
        }
        catch (IOException e) {
            this.info(String.format("could not load jobs in file %s", file.getAbsolutePath()));
            return;
        }
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            Matcher matcher;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(matcher = JOB_XML_PATTERN.matcher(entry.getName())).matches()) continue;
            this.info(matcher.group(1));
        }
    }

    private void findInDirectory(File file) {
        String[] batches = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        if (batches != null) {
            for (String batch : batches) {
                this.info(batch);
            }
        }
    }

    private static File toFile(URL url) {
        String externalForm = url.toExternalForm();
        File file = "jar".equals(url.getProtocol()) ? new File(externalForm.substring("jar:file:".length(), externalForm.lastIndexOf(33))) : ("file".equals(url.getProtocol()) ? new File(externalForm.substring("file:".length())) : null);
        return file;
    }
}

