/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cli.command;

import io.airlift.command.Arguments;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.StepExecution;
import org.apache.batchee.cli.command.SocketConfigurableCommand;
import org.apache.batchee.util.Batches;
import org.apache.commons.io.IOUtils;

public abstract class StartableCommand
extends SocketConfigurableCommand {
    private static final String LINE = "=========================";
    @Arguments(description="properties to pass to the batch")
    protected List<String> properties;

    @Override
    public void doRun() {
        long id;
        AdminThread adminThread;
        JobOperator operator = this.operator();
        if (this.adminSocket > 0) {
            adminThread = new AdminThread(operator, this.adminSocket);
            adminThread.setName("batchee-admin-thread");
            adminThread.start();
        } else {
            this.info("Admin mode deactivated, use -socket to activate it");
            adminThread = null;
        }
        try {
            id = this.doStart(operator);
        }
        catch (Exception e) {
            if (adminThread != null && adminThread.getServerSocket() != null) {
                IOUtils.closeQuietly((ServerSocket)adminThread.getServerSocket());
            }
            e.printStackTrace();
            return;
        }
        if (this.wait) {
            Batches.waitForEnd((JobOperator)operator, (long)id);
            this.report(operator, id);
        }
        if (adminThread != null) {
            adminThread.setId(id);
        }
    }

    protected abstract long doStart(JobOperator var1);

    private void report(JobOperator operator, long id) {
        JobExecution execution = operator.getJobExecution(id);
        this.info("");
        this.info(LINE);
        this.info("Batch status: " + StartableCommand.statusToString(execution.getBatchStatus()));
        this.info("Exit status:  " + execution.getExitStatus());
        if (execution.getEndTime() != null && execution.getStartTime() != null) {
            this.info("Duration:     " + TimeUnit.MILLISECONDS.toSeconds(execution.getEndTime().getTime() - execution.getStartTime().getTime()) + "s");
        }
        if (BatchStatus.FAILED.equals((Object)execution.getBatchStatus())) {
            List stepExecutions = operator.getStepExecutions(id);
            for (StepExecution stepExecution : stepExecutions) {
                if (!BatchStatus.FAILED.equals((Object)stepExecution.getBatchStatus())) continue;
                this.info("");
                this.info("Step name       : " + stepExecution.getStepName());
                this.info("Step status     : " + StartableCommand.statusToString(stepExecution.getBatchStatus()));
                this.info("Step exit status: " + stepExecution.getExitStatus());
                break;
            }
        }
        this.info(LINE);
    }

    private static String statusToString(BatchStatus status) {
        return status != null ? status.name() : "null";
    }

    protected static Properties toProperties(List<String> properties) {
        Properties props = new Properties();
        if (properties != null) {
            for (String kv : properties) {
                String[] split = kv.split("=");
                if (split.length > 1) {
                    props.setProperty(split[0], split[1]);
                    continue;
                }
                props.setProperty(split[0], "");
            }
        }
        return props;
    }

    private static class AdminThread
    extends Thread {
        private final JobOperator operator;
        private final int adminSocketPort;
        private ServerSocket serverSocket = null;
        private long id = Integer.MIN_VALUE;

        public AdminThread(JobOperator operator, int adminSocket) {
            this.operator = operator;
            this.adminSocketPort = adminSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.serverSocket = new ServerSocket(this.adminSocketPort);
                while (true) {
                    if (Integer.MIN_VALUE != this.id) {
                        if (Batches.isDone((JobOperator)this.operator, (long)this.id)) return;
                    }
                    Socket client = this.serverSocket.accept();
                    OutputStream outputStream = client.getOutputStream();
                    AdminThread adminThread = this;
                    synchronized (adminThread) {
                        try {
                            String[] command = IOUtils.toString((InputStream)client.getInputStream()).trim().split(" ");
                            if (command.length >= 2) {
                                long id;
                                block19: {
                                    id = Long.parseLong(command[1]);
                                    try {
                                        if ("stop".equals(command[0])) {
                                            this.operator.stop(id);
                                            break block19;
                                        }
                                        if ("abandon".equals(command[0])) {
                                            this.operator.abandon(id);
                                        }
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                if (command.length >= 3 && Boolean.parseBoolean(command[2])) {
                                    Batches.waitForEnd((long)id);
                                }
                                outputStream.write(0);
                            } else {
                                outputStream.write(-1);
                            }
                            outputStream.flush();
                        }
                        finally {
                            IOUtils.closeQuietly((Socket)client);
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                IOUtils.closeQuietly((ServerSocket)this.serverSocket);
            }
        }

        public ServerSocket getServerSocket() {
            return this.serverSocket;
        }

        public void setId(long id) {
            this.id = id;
        }
    }
}

