/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cdi.impl;

import jakarta.batch.runtime.context.JobContext;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.batchee.cdi.impl.BaseContext;
import org.apache.batchee.cdi.scope.JobScoped;

@Typed
public class JobContextImpl
extends BaseContext {
    private ConcurrentMap<Long, AtomicInteger> jobReferences = new ConcurrentHashMap<Long, AtomicInteger>();

    JobContextImpl(BeanManager bm) {
        super(bm);
    }

    public Class<? extends Annotation> getScope() {
        return JobScoped.class;
    }

    @Override
    protected Long currentKey() {
        JobContext jobContext = this.getContextResolver().getJobContext();
        if (jobContext == null) {
            return null;
        }
        return jobContext.getExecutionId();
    }

    public void enterJobExecution() {
        AtomicInteger oldJobRefs;
        Long jobExecutionId = this.currentKey();
        AtomicInteger jobRefs = (AtomicInteger)this.jobReferences.get(jobExecutionId);
        if (jobRefs == null && (oldJobRefs = this.jobReferences.putIfAbsent(jobExecutionId, jobRefs = new AtomicInteger(0))) != null) {
            jobRefs = oldJobRefs;
        }
        jobRefs.incrementAndGet();
    }

    public void exitJobExecution() {
        int references;
        Long jobExecutionId = this.currentKey();
        AtomicInteger jobRefs = (AtomicInteger)this.jobReferences.get(jobExecutionId);
        if (jobRefs != null && (references = jobRefs.decrementAndGet()) == 0) {
            this.endContext(jobExecutionId);
        }
    }
}

