/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.cdi.impl;

import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import org.apache.batchee.cdi.impl.ContextResolver;

class DynamicContextResolver
implements ContextResolver {
    private final BeanManager bm;

    DynamicContextResolver(BeanManager bm) {
        this.bm = bm;
    }

    @Override
    public JobContext getJobContext() {
        return this.resolve(JobContext.class);
    }

    @Override
    public StepContext getStepContext() {
        return this.resolve(StepContext.class);
    }

    private <T> T resolve(Class<T> contextClass) {
        Bean bean = this.bm.resolve(this.bm.getBeans(contextClass, new Annotation[0]));
        return (T)this.bm.getReference(bean, contextClass, this.bm.createCreationalContext((Contextual)bean));
    }
}

