/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.camel;

import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.ItemWriter;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.List;
import org.apache.batchee.camel.CamelBridge;
import org.apache.batchee.doc.api.Documentation;

@Documentation(value="Uses camel to write processed items.")
public class CamelItemWriter
implements ItemWriter {
    @Inject
    @BatchProperty
    @Documentation(value="Endpoint URI")
    private String endpoint;
    @Inject
    @BatchProperty
    @Documentation(value="Locator for the producer template")
    private String templateLocator;

    public void writeItems(List<Object> items) throws Exception {
        for (Object item : items) {
            CamelBridge.process(this.templateLocator, this.endpoint, item);
        }
    }

    public void close() throws Exception {
    }

    public void open(Serializable checkpoint) throws Exception {
    }

    public Serializable checkpointInfo() throws Exception {
        return null;
    }
}

