/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.tx;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.kernel.TransportListener;
import org.osgi.framework.BundleContext;

public class HttpListener
implements TransportListener {
    private BundleContext context;
    private ConfigurationContext configCtx;

    public HttpListener(BundleContext context) {
        this.context = context;
    }

    @Override
    public void init(ConfigurationContext configCtx, TransportInDescription transprtIn) throws AxisFault {
        this.configCtx = configCtx;
    }

    @Override
    public void start() throws AxisFault {
    }

    @Override
    public void stop() throws AxisFault {
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.calculateEndpoint("http", serviceName, ip);
    }

    @Override
    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        return new EndpointReference[]{this.calculateEndpoint("http", serviceName, ip)};
    }

    @Override
    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    @Override
    public void destroy() {
    }

    private EndpointReference calculateEndpoint(String protocol, String serviceName, String ip) {
        String contextRoot;
        String servicePath;
        String portS = this.context.getProperty("org.osgi.service.http.port");
        int port = 80;
        if (portS != null && portS.length() != 0) {
            try {
                port = Integer.parseInt(portS);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((servicePath = this.configCtx.getServicePath()).startsWith("/")) {
            servicePath = servicePath.substring(1);
        }
        if ((contextRoot = this.configCtx.getContextRoot()) == null || contextRoot.equals("/")) {
            contextRoot = "";
        }
        return new EndpointReference(protocol + "://" + ip + ":" + port + contextRoot + "/" + servicePath + "/" + serviceName + "/");
    }
}

