/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.java;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.DefaultObjectSupplier;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.rpc.receivers.RPCUtil;
import org.apache.axis2.transport.TransportSender;

public class JavaTransportSender
extends AbstractHandler
implements TransportSender {
    @Override
    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    @Override
    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    @Override
    public void stop() {
    }

    @Override
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        SOAPEnvelope resultEnvelope = this.invokeJavaMethod(msgContext);
        MessageContext responseMCObject = msgContext.getOperationContext().getMessageContext("In");
        if (responseMCObject != null) {
            MessageContext responseMC = responseMCObject;
            responseMC.setEnvelope(resultEnvelope);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private SOAPEnvelope invokeJavaMethod(MessageContext inMessage) throws AxisFault {
        Object resObject;
        Object obj;
        Class<?> ImplClass;
        Parameter implementationClass = inMessage.getParameter("className");
        if (implementationClass == null) {
            throw new AxisFault("Service Class Paramater does not find for the service : " + inMessage.getAxisService().getName());
        }
        Object serviceImpleClass = implementationClass.getValue();
        try {
            ImplClass = Class.forName(serviceImpleClass.toString());
            obj = ImplClass.newInstance();
        }
        catch (Exception e) {
            throw new AxisFault("Exception occur while creating [ " + serviceImpleClass + " ]", e);
        }
        AxisService service = inMessage.getAxisService();
        OMElement methodElement = inMessage.getEnvelope().getBody().getFirstElement();
        String messageNameSpace = inMessage.getAxisService().getTargetNamespace();
        String methodName = methodElement.getLocalName();
        Method method = null;
        Method[] methods = ImplClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            method = methods[i];
            break;
        }
        if (method == null) {
            throw new AxisFault("method : " + methodName + " : does not find in the service implementation class : " + serviceImpleClass);
        }
        DefaultObjectSupplier obj1 = new DefaultObjectSupplier();
        Object[] objectArray = RPCUtil.processRequest(methodElement, method, obj1);
        try {
            resObject = method.invoke(obj, objectArray);
        }
        catch (Exception e) {
            throw new AxisFault("Error occured while invoking the method [ " + methodName + " ]", e);
        }
        SOAPFactory fac = this.getSOAPFactory(inMessage);
        OMNamespace ns = fac.createOMNamespace(messageNameSpace, service.getSchemaTargetNamespacePrefix());
        SOAPEnvelope envelope = fac.getDefaultEnvelope();
        OMElement bodyContent = null;
        if (resObject == null) {
            envelope.getBody().addChild((OMNode)fac.createOMElement("item", ns));
        } else if (resObject instanceof Object[]) {
            QName resName = new QName(service.getSchemaTargetNamespace(), method.getName() + "Response", service.getSchemaTargetNamespacePrefix());
            OMElement bodyChild = RPCUtil.getResponseElement(resName, (Object[])resObject, false, null);
            bodyChild.addAttribute("returnType", method.getReturnType().getClass().getName() + ((Object[])resObject).length, envelope.getBody().getDefaultNamespace());
            envelope.getBody().addChild((OMNode)bodyChild);
        } else {
            RPCUtil.processResponse(fac, resObject, bodyContent, ns, envelope, method, false, null);
            envelope.getBody().getFirstElement().addAttribute("returnType", method.getReturnType().getClass().getName(), envelope.getBody().getDefaultNamespace());
        }
        return envelope;
    }

    private SOAPFactory getSOAPFactory(MessageContext msgContext) throws AxisFault {
        String nsURI = msgContext.getEnvelope().getNamespace().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage("invalidSOAPversion"));
    }
}

