/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.deployment;

import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.osgi.deployment.OSGiAxis2Constants;

public class OSGiServiceBuilder
extends ServiceBuilder {
    private AxisService service;

    public OSGiServiceBuilder(ConfigurationContext configCtx, AxisService service) {
        super(configCtx, service);
        this.service = service;
    }

    public OSGiServiceBuilder(InputStream serviceInputStream, ConfigurationContext configCtx, AxisService service) {
        super(serviceInputStream, configCtx, service);
        this.service = service;
    }

    @Override
    protected void processModuleRefs(Iterator moduleRefs) throws DeploymentException {
        while (moduleRefs.hasNext()) {
            OMElement moduleref = (OMElement)moduleRefs.next();
            OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
            if (moduleRefAttribute == null) continue;
            String refName = moduleRefAttribute.getAttributeValue();
            if (this.axisConfig.getModule(refName) == null) {
                throw new DeploymentException(OSGiAxis2Constants.MODULE_NOT_FOUND_ERROR);
            }
            this.service.addModuleref(refName);
        }
    }

    @Override
    protected void processOperationModuleRefs(Iterator moduleRefs, AxisOperation operation) throws DeploymentException {
        while (moduleRefs.hasNext()) {
            OMElement moduleref = (OMElement)moduleRefs.next();
            OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
            if (moduleRefAttribute == null) continue;
            String refName = moduleRefAttribute.getAttributeValue();
            if (this.axisConfig.getModule(refName) == null) {
                throw new DeploymentException(OSGiAxis2Constants.MODULE_NOT_FOUND_ERROR + refName);
            }
            operation.addModule(refName);
        }
    }
}

