/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.deployment;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.ModuleBuilder;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Version;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.modules.Module;
import org.apache.axis2.osgi.deployment.AbstractRegistry;
import org.apache.axis2.osgi.deployment.BundleClassLoader;
import org.apache.axis2.osgi.deployment.OSGiAxis2Constants;
import org.apache.axis2.osgi.deployment.Registry;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ModuleRegistry
extends AbstractRegistry<AxisModule> {
    private static Log log = LogFactory.getLog(ModuleRegistry.class);
    private Registry serviceRegistry;

    public ModuleRegistry(BundleContext context, ConfigurationContext configCtx, Registry serviceRegistry) {
        super(context, configCtx);
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void register(Bundle bundle) {
        this.lock.lock();
        try {
            this.addModules(bundle);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegister(Bundle bundle, boolean uninstall) {
        block13: {
            this.lock.lock();
            try {
                List moduleList = (List)this.resolvedBundles.get(bundle);
                if (moduleList == null) break block13;
                ArrayList<Object> stopBundleList = new ArrayList<Object>();
                for (AxisModule axisModule : moduleList) {
                    Object value;
                    AxisConfiguration axisConfig = this.configCtx.getAxisConfiguration();
                    Iterator<AxisServiceGroup> iterator = axisConfig.getServiceGroups();
                    while (iterator.hasNext()) {
                        AxisServiceGroup axisServiceGroup = iterator.next();
                        if (!axisServiceGroup.isEngaged(axisModule) || (value = (Long)axisServiceGroup.getParameterValue(OSGiAxis2Constants.OSGi_BUNDLE_ID)) == null) continue;
                        stopBundleList.add(value);
                    }
                    HashMap<String, AxisService> serviceMap = axisConfig.getServices();
                    Collection<AxisService> values = serviceMap.values();
                    value = values.iterator();
                    while (value.hasNext()) {
                        Long value2;
                        Object value1 = value.next();
                        AxisService axisService = (AxisService)value1;
                        if (axisService.isEngaged(axisModule) && (value2 = (Long)axisService.getParameterValue(OSGiAxis2Constants.OSGi_BUNDLE_ID)) != null && !stopBundleList.contains(value2)) {
                            stopBundleList.add(value2);
                        }
                        Iterator<AxisOperation> iterator1 = axisService.getOperations();
                        while (iterator1.hasNext()) {
                            Long value3;
                            AxisOperation axisOperation = iterator1.next();
                            if (!axisOperation.isEngaged(axisModule) || (value3 = (Long)axisOperation.getParameterValue(OSGiAxis2Constants.OSGi_BUNDLE_ID)) == null || stopBundleList.contains(value3)) continue;
                            stopBundleList.add(value3);
                        }
                    }
                    Module moduleInterface = axisModule.getModule();
                    if (moduleInterface != null) {
                        try {
                            moduleInterface.shutdown(this.configCtx);
                        }
                        catch (AxisFault e) {
                            String msg = "Error while shutting down the module : " + axisModule.getName() + " : " + axisModule.getVersion() + " moduel in Bundle - " + bundle.getSymbolicName();
                            log.error((Object)msg, (Throwable)e);
                        }
                    }
                    axisConfig.removeModule(axisModule.getName(), axisModule.getVersion());
                    if (this.resolvedBundles.containsKey(bundle)) {
                        this.resolvedBundles.remove(bundle);
                    }
                    log.info((Object)("[Axis2/OSGi] Stopping :" + axisModule.getName() + " : " + axisModule.getVersion() + " moduel in Bundle - " + bundle.getSymbolicName()));
                }
                for (Long l : stopBundleList) {
                    Bundle unRegBundle = this.context.getBundle(l.longValue());
                    if (unRegBundle == null) continue;
                    this.serviceRegistry.unRegister(unRegBundle, false);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void addModules(Bundle bundle) {
        if (!this.resolvedBundles.containsKey(bundle)) {
            Enumeration enumeration = bundle.findEntries("META-INF", "*module.xml", false);
            ArrayList<AxisModule> moduleList = null;
            if (enumeration != null) {
                moduleList = new ArrayList<AxisModule>();
            }
            while (enumeration != null && enumeration.hasMoreElements()) {
                try {
                    String bundleVersion;
                    URL url = (URL)enumeration.nextElement();
                    AxisModule axismodule = new AxisModule();
                    BundleClassLoader loader = new BundleClassLoader(bundle, Registry.class.getClassLoader());
                    axismodule.setModuleClassLoader(loader);
                    AxisConfiguration axisConfig = this.configCtx.getAxisConfiguration();
                    ModuleBuilder builder = new ModuleBuilder(url.openStream(), axismodule, axisConfig);
                    Dictionary headers = bundle.getHeaders();
                    String bundleSymbolicName = (String)headers.get("Bundle-SymbolicName");
                    if (bundleSymbolicName != null && bundleSymbolicName.length() != 0) {
                        axismodule.setName(bundleSymbolicName);
                    }
                    if ((bundleVersion = (String)headers.get("Bundle-Version")) != null && bundleVersion.length() != 0) {
                        String[] versionSplit = bundleVersion.split("\\.");
                        int[] components = new int[Math.min(versionSplit.length, 3)];
                        for (int i = 0; i < components.length; ++i) {
                            components[i] = Integer.parseInt(versionSplit[i]);
                        }
                        axismodule.setVersion(new Version(components, versionSplit.length > 3 ? versionSplit[3] : null));
                    }
                    builder.populateModule();
                    axismodule.setParent(axisConfig);
                    AxisModule module = axisConfig.getModule(axismodule.getName());
                    if (module == null) {
                        DeploymentEngine.addNewModule(axismodule, axisConfig);
                        Module moduleObj = axismodule.getModule();
                        if (moduleObj != null) {
                            moduleObj.init(this.configCtx, axismodule);
                        }
                        moduleList.add(axismodule);
                        log.info((Object)("[Axis2/OSGi] Starting any modules in Bundle - " + bundle.getSymbolicName() + " - Module Name : " + axismodule.getName() + " - Module Version : " + axismodule.getVersion()));
                    } else {
                        log.info((Object)("[ModuleRegistry] Module : " + axismodule.getName() + " is already available."));
                    }
                    Utils.calculateDefaultModuleVersion(axisConfig.getModules(), axisConfig);
                    this.serviceRegistry.resolve();
                }
                catch (IOException e) {
                    String msg = "Error while reading module.xml";
                    log.error((Object)msg, (Throwable)e);
                }
            }
            if (moduleList != null && moduleList.size() > 0) {
                this.resolvedBundles.put(bundle, moduleList);
            }
        }
    }

    @Override
    public void remove(Bundle bundle) {
        this.unRegister(bundle, true);
    }
}

