/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.osgi.internal;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.osgi.OSGiAxisServlet;
import org.apache.axis2.osgi.deployment.OSGiAxis2Constants;
import org.apache.axis2.osgi.deployment.OSGiConfigurationContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Log log = LogFactory.getLog(Activator.class);
    private HttpServiceTracker tracker;
    private final OSGiConfigurationContextFactory managedService = new OSGiConfigurationContextFactory();

    public void start(BundleContext context) throws Exception {
        this.managedService.start(context);
        this.managedService.updated(null);
        this.tracker = new HttpServiceTracker(context);
        this.tracker.open();
    }

    public void stop(BundleContext context) {
        this.tracker.close();
        this.managedService.stop();
        ServiceReference configCtxRef = context.getServiceReference(ConfigurationContext.class.getName());
        if (configCtxRef != null) {
            context.ungetService(configCtxRef);
        }
    }

    class HttpServiceTracker
    extends ServiceTracker {
        public HttpServiceTracker(BundleContext context) {
            super(context, HttpService.class.getName(), null);
        }

        public Object addingService(ServiceReference serviceReference) {
            HttpService httpService = (HttpService)this.context.getService(serviceReference);
            try {
                OSGiAxisServlet axisServlet = new OSGiAxisServlet(this.context);
                ServiceReference configCtxRef = this.context.getServiceReference(ConfigurationContext.class.getName());
                ConfigurationContext configCtx = (ConfigurationContext)this.context.getService(configCtxRef);
                String propServiceContextRoot = this.context.getProperty(OSGiAxis2Constants.AXIS2_OSGi_ROOT_CONTEXT);
                String serviceContextRoot = "services";
                if (propServiceContextRoot != null && propServiceContextRoot.length() != 0) {
                    serviceContextRoot = propServiceContextRoot.startsWith("/") ? propServiceContextRoot.substring(1) : propServiceContextRoot;
                }
                configCtx.setServicePath(serviceContextRoot);
                String contextRoot = "/" + serviceContextRoot;
                log.info((Object)("Registering SOAP message listener servlet to context : " + contextRoot));
                httpService.registerServlet(contextRoot, (Servlet)axisServlet, null, null);
            }
            catch (ServletException e) {
                String msg = "Error while registering servlets";
                log.error((Object)msg, (Throwable)e);
            }
            catch (NamespaceException e) {
                String msg = "Namespace missmatch when registering servlets";
                log.error((Object)msg, (Throwable)e);
            }
            return httpService;
        }
    }
}

