/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.webapp;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.webapp.ActionResult;
import org.apache.axis2.webapp.Redirect;

final class ActionHandler {
    private final Object target;
    private final Method method;
    private final boolean authorizationRequired;
    private final boolean post;
    private final boolean sessionCreationAllowed;

    ActionHandler(Object target, Method method, boolean authorizationRequired, boolean post, boolean sessionCreationAllowed) {
        this.target = target;
        this.method = method;
        this.authorizationRequired = authorizationRequired;
        this.post = post;
        this.sessionCreationAllowed = sessionCreationAllowed;
    }

    boolean isMethodAllowed(String method) {
        return this.post ? method.equals("POST") : method.equals("GET");
    }

    boolean isCSRFTokenRequired() {
        return this.post && this.authorizationRequired;
    }

    boolean isSessionCreationAllowed() {
        return this.sessionCreationAllowed;
    }

    ActionResult handle(HttpServletRequest request, boolean securityEnabled) throws IOException, ServletException {
        HttpSession session = request.getSession(false);
        if (securityEnabled && this.authorizationRequired && (session == null || session.getAttribute("Logged") == null)) {
            return new Redirect("welcome");
        }
        try {
            return (ActionResult)this.method.invoke(this.target, request);
        }
        catch (IllegalAccessException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            throw new ServletException(cause);
        }
    }
}

