/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.testkit.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.axis2.transport.testkit.tests.ManagedTestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.TTCCLayout;
import org.apache.log4j.WriterAppender;

public class LogManager {
    public static final LogManager INSTANCE = new LogManager();
    private final File logDir = new File("target" + File.separator + "testkit-logs");
    private File testCaseDir;
    private WriterAppender appender;
    private int sequence;
    private List<OutputStream> logs;

    private LogManager() {
    }

    public void setTestCase(ManagedTestCase testCase) throws IOException {
        if (this.appender != null) {
            Logger.getRootLogger().removeAppender((Appender)this.appender);
            this.appender.close();
            this.appender = null;
        }
        if (this.logs != null) {
            for (OutputStream log : this.logs) {
                IOUtils.closeQuietly((OutputStream)log);
            }
            this.logs = null;
        }
        if (testCase == null) {
            this.testCaseDir = null;
        } else {
            File testSuiteDir = new File(this.logDir, testCase.getTestClass().getName());
            this.testCaseDir = new File(testSuiteDir, testCase.getId());
            this.logs = new LinkedList<OutputStream>();
            this.sequence = 1;
            this.appender = new WriterAppender((Layout)new TTCCLayout(), this.createLog("debug"));
            Logger.getRootLogger().addAppender((Appender)this.appender);
        }
    }

    public synchronized boolean isLoggingEnabled() {
        return this.testCaseDir != null;
    }

    public synchronized OutputStream createLog(String name) throws IOException {
        this.testCaseDir.mkdirs();
        FileOutputStream log = new FileOutputStream(new File(this.testCaseDir, StringUtils.leftPad((String)String.valueOf(this.sequence++), (int)2, (char)'0') + "-" + name + ".log"));
        this.logs.add(log);
        return log;
    }
}

