/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFaultElement;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11FaultDetailImpl;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11FaultReasonImpl;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11FaultRoleImpl;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11FaultTextImpl;
import org.apache.axis2.saaj.DetailImpl;
import org.apache.axis2.saaj.SOAPBodyElementImpl;
import org.apache.axis2.saaj.SOAPFaultElementImpl;

public class SOAPFaultImpl
extends SOAPBodyElementImpl
implements javax.xml.soap.SOAPFault {
    protected SOAPFault fault;
    private boolean isDetailAdded;
    private Name faultCodeName;
    private Locale faultReasonLocale;

    public SOAPFaultImpl(SOAPFault fault) {
        super((ElementImpl)fault);
        this.fault = fault;
    }

    public void setFaultCode(String faultCode) throws SOAPException {
        SOAPFactory soapFactory = DOOMAbstractFactory.getSOAP11Factory();
        SOAPFaultCode fCode = soapFactory.createSOAPFaultCode(this.fault);
        SOAPFaultValue fValue = soapFactory.createSOAPFaultValue(fCode);
        fCode.setValue(fValue);
        fValue.setText(faultCode);
        this.fault.setCode(fCode);
    }

    public String getFaultCode() {
        if (this.fault != null && this.fault.getCode() != null && this.fault.getCode().getValue() != null) {
            return this.fault.getCode().getValue().getText();
        }
        return null;
    }

    public void setFaultActor(String faultActor) throws SOAPException {
        if (this.fault.getRole() == null) {
            SOAP11FaultRoleImpl faultRoleImpl = new SOAP11FaultRoleImpl(this.fault, (SOAPFactory)this.element.getOMFactory());
            faultRoleImpl.setRoleValue(faultActor);
            this.fault.setRole((SOAPFaultRole)faultRoleImpl);
        } else {
            SOAPFaultRole role = this.fault.getRole();
            role.setRoleValue(faultActor);
        }
    }

    public String getFaultActor() {
        if (this.fault.getRole() != null) {
            return this.fault.getRole().getRoleValue();
        }
        return null;
    }

    public void setFaultString(String faultString) throws SOAPException {
        if (this.fault.getReason() != null) {
            SOAPFaultReason reason = this.fault.getReason();
            if (reason.getFirstSOAPText() != null) {
                reason.getFirstSOAPText().getFirstOMChild().detach();
                reason.getFirstSOAPText().setText(faultString);
            } else {
                SOAP11FaultTextImpl text = new SOAP11FaultTextImpl(reason, (SOAPFactory)this.element.getOMFactory());
                text.setText(faultString);
                reason.addSOAPText((SOAPFaultText)text);
            }
        } else {
            SOAPFactory soapFactory = DOOMAbstractFactory.getSOAP11Factory();
            SOAPFaultReason fReason = soapFactory.createSOAPFaultReason(this.fault);
            SOAPFaultText fText = soapFactory.createSOAPFaultText(fReason);
            fText.setText(faultString);
        }
    }

    public String getFaultString() {
        if (this.fault.getReason() != null && this.fault.getReason().getFirstSOAPText() != null) {
            return this.fault.getReason().getFirstSOAPText().getText();
        }
        return null;
    }

    public Detail getDetail() {
        return (Detail)this.toSAAJNode((org.w3c.dom.Node)this.fault.getDetail());
    }

    public void setFaultCode(Name name) throws SOAPException {
        this.faultCodeName = name;
    }

    public Detail addDetail() throws SOAPException {
        if (this.isDetailAdded) {
            throw new SOAPException("This SOAPFault already contains a Detail element. Please remove the existing Detail element before calling addDetail()");
        }
        SOAP11FaultDetailImpl omDetail = new SOAP11FaultDetailImpl(this.fault, (SOAPFactory)this.element.getOMFactory());
        DetailImpl saajDetail = new DetailImpl((SOAPFaultDetail)omDetail);
        ((NodeImpl)this.fault.getDetail()).setUserData("saaj.node", (Object)saajDetail, null);
        this.isDetailAdded = true;
        return saajDetail;
    }

    public Name getFaultCodeAsName() {
        return this.faultCodeName;
    }

    public void setFaultString(String faultString, Locale locale) throws SOAPException {
        if (this.fault.getReason() != null) {
            SOAPFaultReason reason = this.fault.getReason();
            if (reason.getFirstSOAPText() != null) {
                reason.getFirstSOAPText().setText(faultString);
                reason.getFirstSOAPText().setLang(locale.getLanguage());
            } else {
                SOAP11FaultTextImpl text = new SOAP11FaultTextImpl(reason, (SOAPFactory)this.element.getOMFactory());
                text.setText(faultString);
                text.setLang(locale.getLanguage());
                reason.addSOAPText((SOAPFaultText)text);
            }
        } else {
            SOAP11FaultReasonImpl reason = new SOAP11FaultReasonImpl(this.fault, (SOAPFactory)this.element.getOMFactory());
            SOAP11FaultTextImpl text = new SOAP11FaultTextImpl((SOAPFaultReason)reason, (SOAPFactory)this.element.getOMFactory());
            text.setText(faultString);
            text.setLang(locale.getLanguage());
            reason.addSOAPText((SOAPFaultText)text);
            this.fault.setReason((SOAPFaultReason)reason);
        }
        this.faultReasonLocale = locale;
    }

    public Locale getFaultStringLocale() {
        return this.faultReasonLocale;
    }

    public Iterator getChildElements(Name name) {
        QName qName = new QName(name.getURI(), name.getLocalName());
        return this.getChildren(this.element.getChildrenWithName(qName));
    }

    public Iterator getChildElements() {
        return this.getChildren(this.element.getChildren());
    }

    private Iterator getChildren(Iterator childIter) {
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            org.w3c.dom.Node domNode = (org.w3c.dom.Node)childIter.next();
            Node saajNode = this.toSAAJNode(domNode);
            if (!(saajNode instanceof SOAPFaultElement)) {
                SOAPFaultElementImpl bodyEle = new SOAPFaultElementImpl((ElementImpl)domNode);
                ((NodeImpl)domNode).setUserData("saaj.node", (Object)bodyEle, null);
                childElements.add(bodyEle);
                continue;
            }
            childElements.add(saajNode);
        }
        return childElements.iterator();
    }
}

